/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit;

import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.jboss.el.ExpressionFactoryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.storage.sql.SQLRepositoryTestCase;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.el.ExpressionEvaluator;

public class TestExtendedInfoEvaluation
extends SQLRepositoryTestCase {
    protected ExpressionEvaluator evaluatorUnderTest;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.evaluatorUnderTest = new ExpressionEvaluator((ExpressionFactory)new ExpressionFactoryImpl());
        this.openSession();
    }

    @After
    public void tearDown() throws Exception {
        this.closeSession();
        super.tearDown();
    }

    protected DocumentModel doCreateDocument() throws ClientException {
        DocumentModel rootDocument = this.session.getRootDocument();
        DocumentModel model = this.session.createDocumentModel(rootDocument.getPathAsString(), "youps", "File");
        model.setProperty("dublincore", "title", (Object)"huum");
        return this.session.createDocument(model);
    }

    @Test
    public void testBean() throws ClientException {
        ExpressionContext context = new ExpressionContext();
        DocumentModel source = this.doCreateDocument();
        DocumentEventContext eventContext = new DocumentEventContext(this.session, this.session.getPrincipal(), source);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        eventContext.setProperties(properties);
        this.evaluatorUnderTest.bindValue((ELContext)context, "context", (Object)eventContext);
        DocumentModel value = (DocumentModel)this.evaluatorUnderTest.evaluateExpression((ELContext)context, "${context.arguments[0]}", DocumentModel.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)source, (Object)value);
        String test = (String)this.evaluatorUnderTest.evaluateExpression((ELContext)context, "${context.properties.test}", String.class);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"test", (Object)test);
    }
}

