/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaCollections;
import ch.lambdaj.function.closure.Closure1;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.lordofthejars.nosqlunit.redis.embedded.ByteArray2ByteBufferConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBuffer2ByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBufferAsString2DoubleConverter;
import com.lordofthejars.nosqlunit.redis.embedded.DoubleToStringByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.RangeUtils;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ZParams;
import redis.clients.util.SafeEncoder;

public class SortsetDatatypeOperations
extends ExpirationDatatypeOperations
implements RedisDatatypeOperations {
    protected static final String ZSET = "zset";
    protected Multimap<ByteBuffer, ScoredByteBuffer> sortset = TreeMultimap.create();

    public Long zadd(byte[] key, double score, byte[] member) {
        ScoredByteBuffer previousMember;
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.sortset.containsKey((Object)wrappedKey) && this.isMemberAlreadyAdded(previousMember = this.findScoredByteBufferByKeyAndMember(member, wrappedKey))) {
            this.removeAndUpdateElement(score, member, wrappedKey, previousMember);
            return 0L;
        }
        this.sortset.put((Object)wrappedKey, (Object)ScoredByteBuffer.createScoredByteBuffer(ByteBuffer.wrap(member), score));
        return 1L;
    }

    private void removeAndUpdateElement(double score, byte[] member, ByteBuffer wrappedKey, ScoredByteBuffer previousMember) {
        this.sortset.remove((Object)wrappedKey, (Object)previousMember);
        this.sortset.put((Object)wrappedKey, (Object)ScoredByteBuffer.createScoredByteBuffer(ByteBuffer.wrap(member), score));
    }

    private ScoredByteBuffer findScoredByteBufferByKeyAndMember(byte[] member, ByteBuffer wrappedKey) {
        Collection members = this.sortset.get((Object)wrappedKey);
        ScoredByteBuffer previousMember = (ScoredByteBuffer)Lambda.selectUnique((Object)members, (Matcher)Lambda.having((Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer(), (Matcher)CoreMatchers.equalTo((Object)ByteBuffer.wrap(member))));
        return previousMember;
    }

    private boolean isMemberAlreadyAdded(ScoredByteBuffer previousMember) {
        return previousMember != null;
    }

    public Long zadd(byte[] key, Map<Double, byte[]> scoreMembers) {
        long insertedElements = 0L;
        Set<Map.Entry<Double, byte[]>> scoreMemberSet = scoreMembers.entrySet();
        for (Map.Entry<Double, byte[]> entry : scoreMemberSet) {
            insertedElements += this.zadd(key, entry.getKey(), entry.getValue()).longValue();
        }
        return insertedElements;
    }

    public Long zcard(byte[] key) {
        return this.sortset.get((Object)ByteBuffer.wrap(key)).size();
    }

    public Long zcount(byte[] key, double min, double max) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        long numberOfElementsMeetingCondition = this.countNumberOfElementsBetweenInclusiveScores(min, max, elements);
        return numberOfElementsMeetingCondition;
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        String minValueString = SafeEncoder.encode((byte[])min);
        String maxValueString = SafeEncoder.encode((byte[])max);
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        double minValue = RangeUtils.getRealScoreForMinValue(minValueString, elements);
        double maxValue = RangeUtils.getRealScoreForMaxValue(maxValueString, elements);
        long numberOfElementsMeetingCondition = this.countNumberOfElementsBetweenInclusiveScores(minValue, maxValue, elements);
        return numberOfElementsMeetingCondition;
    }

    private long countNumberOfElementsBetweenInclusiveScores(double min, double max, Collection<ScoredByteBuffer> elements) {
        long numberOfElementsMeetingCondition = 0L;
        for (ScoredByteBuffer scoredByteBuffer : elements) {
            double score = scoredByteBuffer.getScore();
            if (!(score >= min) || !(score <= max)) continue;
            ++numberOfElementsMeetingCondition;
        }
        return numberOfElementsMeetingCondition;
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        ScoredByteBuffer memberToUpdate = this.findScoredByteBufferByKeyAndMember(member, wrappedKey);
        if (memberToUpdate != null) {
            double newScore = memberToUpdate.getScore() + score;
            this.removeAndUpdateElement(newScore, member, wrappedKey, memberToUpdate);
            return newScore;
        }
        this.sortset.put((Object)wrappedKey, (Object)ScoredByteBuffer.createScoredByteBuffer(ByteBuffer.wrap(member), score));
        return score;
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        ZParams zParams = new ZParams();
        return this.zunionstore(dstkey, zParams, sets);
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Closure1 union = Lambda.closure(List.class);
        ((SortsetDatatypeOperations)Lambda.of((Object)this)).unionElements((List)Lambda.var(List.class));
        return this.zXStore(dstkey, params, (Closure1<List>)union, sets);
    }

    private Long zXStore(byte[] dstkey, ZParams params, Closure1<List> operation, byte[] ... sets) {
        this.sortset.removeAll((Object)ByteBuffer.wrap(dstkey));
        List parameters = Lambda.convert((Object)params.getParams(), (Converter)new ByteArray2ByteBufferConverter());
        String typeOfAggregation = this.getTypeOfAggregationAndRemoveFromAggregationParameters(parameters);
        List<ByteBuffer> weightValues = this.getWeightValues(parameters);
        if (!this.areWeightValuesCorrectlySet(weightValues, sets)) {
            throw new IllegalArgumentException("ERR syntax error. Number of sets and weights are not correct.");
        }
        Set storeElements = (Set)operation.apply(Arrays.asList(sets));
        this.updateDestinationWithZParams(dstkey, typeOfAggregation, weightValues, storeElements, sets);
        return this.zcard(dstkey);
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        ZParams zParams = new ZParams();
        return this.zinterstore(dstkey, zParams, sets);
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        Closure1 union = Lambda.closure(List.class);
        ((SortsetDatatypeOperations)Lambda.of((Object)this)).intersactionElements((List)Lambda.var(List.class));
        return this.zXStore(dstkey, params, (Closure1<List>)union, sets);
    }

    public Set<byte[]> zrange(byte[] key, int start, int end) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        Set<ScoredByteBuffer> elementsByRange = this.getElementsByRange(elements, start, end);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<ScoredByteBuffer> zrangeWithScores(byte[] key, int start, int end) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        return this.getElementsByRange(elements, start, end);
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    private List<ScoredByteBuffer> getElementsByMetaIntervals(byte[] key, byte[] min, byte[] max) {
        String minString = SafeEncoder.encode((byte[])min);
        String maxString = SafeEncoder.encode((byte[])max);
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        double minValue = RangeUtils.getRealScoreForMinValue(minString, elements);
        double maxValue = RangeUtils.getRealScoreForMaxValue(maxString, elements);
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(elements, minValue, maxValue);
        return elementsByRange;
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max);
        elementsByRange = this.limitResult(elementsByRange, offset, count);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        elementsByRange = this.limitResult(elementsByRange, offset, count);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<ScoredByteBuffer> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return new LinkedHashSet<ScoredByteBuffer>(this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max));
    }

    public Set<ScoredByteBuffer> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        return new LinkedHashSet<ScoredByteBuffer>(this.getElementsByMetaIntervals(key, min, max));
    }

    public Set<ScoredByteBuffer> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max);
        return new LinkedHashSet<ScoredByteBuffer>(this.limitResult(elementsByRange, offset, count));
    }

    public Set<ScoredByteBuffer> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        return new LinkedHashSet<ScoredByteBuffer>(this.limitResult(elementsByRange, offset, count));
    }

    private List<ScoredByteBuffer> limitResult(List<ScoredByteBuffer> elements, int offset, int count) {
        return RangeUtils.limitListByOffsetCount(offset, count, elements);
    }

    private List<ScoredByteBuffer> getElementsByInclusiveRangeScore(Collection<ScoredByteBuffer> elements, double min, double max) {
        List subSelect = Lambda.filter((Matcher)Lambda.having((Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getScore(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Double.valueOf(min))).and((Matcher)Lambda.having((Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getScore(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(max)))), elements);
        return new LinkedList<ScoredByteBuffer>(subSelect);
    }

    public Long zrank(byte[] key, byte[] member) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        long position = 0L;
        for (ScoredByteBuffer scoredByteBuffer : elements) {
            if (scoredByteBuffer.byteBuffer.equals(ByteBuffer.wrap(member))) {
                return position;
            }
            ++position;
        }
        return null;
    }

    public Long zrem(byte[] key, byte[] ... members) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        long removedElements = 0L;
        for (byte[] member : members) {
            int numberOfNoneRemovedElements;
            int numberOfElements = elements.size();
            if (numberOfElements == (numberOfNoneRemovedElements = LambdaCollections.with((Collection)elements).remove((Matcher)Lambda.having((Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer(), (Matcher)CoreMatchers.equalTo((Object)ByteBuffer.wrap(member)))).size())) continue;
            ++removedElements;
        }
        return removedElements;
    }

    public Long zremrangeByRank(byte[] key, int start, int end) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        Set<ScoredByteBuffer> elementsToRemove = this.getElementsByRange(elements, start, end);
        Collection allElements = this.sortset.get((Object)ByteBuffer.wrap(key));
        LambdaCollections.with((Collection)allElements).removeAll(elementsToRemove);
        return elementsToRemove.size();
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        List<ScoredByteBuffer> elementsToRemove = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), start, end);
        return this.removeListOfElements(key, elementsToRemove);
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        List<ScoredByteBuffer> elementsToRemove = this.getElementsByMetaIntervals(key, start, end);
        return this.removeListOfElements(key, elementsToRemove);
    }

    public Set<byte[]> zrevrange(byte[] key, int start, int end) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elements);
        Set<ScoredByteBuffer> elementsByRange = this.getElementsByRange(reverseOrderElements, start, end);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<ScoredByteBuffer> zrevrangeWithScores(byte[] key, int start, int end) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elements);
        Set<ScoredByteBuffer> elementsByRange = this.getElementsByRange(reverseOrderElements, start, end);
        return elementsByRange;
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(elements, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(reverseOrderElements, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(reverseOrderElements, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        elementsByRange = this.limitResult(new LinkedList<ScoredByteBuffer>(reverseOrderElements), offset, count);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        elementsByRange = this.limitResult(new LinkedList<ScoredByteBuffer>(reverseOrderElements), offset, count);
        return new LinkedHashSet<byte[]>(Lambda.convert((Object)Lambda.extract(elementsByRange, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()), (Converter)new ByteBuffer2ByteArrayConverter()));
    }

    public Set<ScoredByteBuffer> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(elements, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return reverseOrderElements;
    }

    public Set<ScoredByteBuffer> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByInclusiveRangeScore(this.sortset.get((Object)ByteBuffer.wrap(key)), min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return new LinkedHashSet<ScoredByteBuffer>(this.limitResult(new LinkedList<ScoredByteBuffer>(reverseOrderElements), offset, count));
    }

    public Set<ScoredByteBuffer> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return reverseOrderElements;
    }

    public Set<ScoredByteBuffer> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        List<ScoredByteBuffer> elementsByRange = this.getElementsByMetaIntervals(key, min, max);
        Set<ScoredByteBuffer> reverseOrderElements = this.reverseElements(elementsByRange);
        return new LinkedHashSet<ScoredByteBuffer>(this.limitResult(new LinkedList<ScoredByteBuffer>(reverseOrderElements), offset, count));
    }

    public Long zrevrank(byte[] key, byte[] member) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        Set<ScoredByteBuffer> reverseElements = this.reverseElements(elements);
        long position = 0L;
        for (ScoredByteBuffer scoredByteBuffer : reverseElements) {
            if (scoredByteBuffer.byteBuffer.equals(ByteBuffer.wrap(member))) {
                return position;
            }
            ++position;
        }
        return null;
    }

    public Double zscore(byte[] key, byte[] member) {
        Collection elements = this.sortset.get((Object)ByteBuffer.wrap(key));
        ScoredByteBuffer requiredElement = (ScoredByteBuffer)Lambda.selectUnique((Object)elements, (Matcher)Lambda.having((Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer(), (Matcher)CoreMatchers.equalTo((Object)ByteBuffer.wrap(member))));
        if (requiredElement != null) {
            return requiredElement.getScore();
        }
        return null;
    }

    private Set<ScoredByteBuffer> reverseElements(Collection<ScoredByteBuffer> elementsByRange) {
        Comparator reverseOrder = Collections.reverseOrder();
        TreeSet<ScoredByteBuffer> reverseOrderElements = new TreeSet<ScoredByteBuffer>(reverseOrder);
        reverseOrderElements.addAll(elementsByRange);
        return reverseOrderElements;
    }

    private Long removeListOfElements(byte[] key, List<ScoredByteBuffer> elementsToRemove) {
        Collection allElements = this.sortset.get((Object)ByteBuffer.wrap(key));
        LambdaCollections.with((Collection)allElements).removeAll(elementsToRemove);
        return elementsToRemove.size();
    }

    private Set<ScoredByteBuffer> getElementsByRange(Collection<ScoredByteBuffer> elements, int start, int end) {
        LinkedList<ScoredByteBuffer> listOfElements = new LinkedList<ScoredByteBuffer>(elements);
        int calculatedStart = RangeUtils.calculateStart(start, listOfElements.size());
        int calculatedEnd = RangeUtils.calculateEnd(end, listOfElements.size());
        try {
            List subList = listOfElements.subList(calculatedStart, calculatedEnd);
            return new LinkedHashSet<ScoredByteBuffer>(subList);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public long getNumberOfKeys() {
        return this.sortset.keySet().size();
    }

    @Override
    public void flushAllKeys() {
        this.removeExpirations();
        this.sortset.clear();
    }

    private void removeExpirations() {
        List<byte[]> keys = this.keys();
        for (byte[] key : keys) {
            this.removeExpiration(key);
        }
    }

    private void updateDestinationWithZParams(byte[] dstkey, String typeOfAggregation, List<ByteBuffer> weightValues, Set<ByteBuffer> elements, byte[] ... sets) {
        for (int i = 0; i < sets.length; ++i) {
            byte[] setKey = sets[i];
            ByteBuffer wrappedKey = ByteBuffer.wrap(setKey);
            for (ByteBuffer elementBuffer : elements) {
                ScoredByteBuffer element = this.findScoredByteBufferByKeyAndMember(elementBuffer.array(), wrappedKey);
                if (element == null) continue;
                double newScore = element.getScore() * (double)this.multiplicationFactor(weightValues, i);
                if (ZParams.Aggregate.SUM.name().equals(typeOfAggregation)) {
                    this.zincrby(dstkey, newScore, elementBuffer.array());
                    continue;
                }
                if (ZParams.Aggregate.MIN.name().equals(typeOfAggregation)) {
                    this.zincrmin(dstkey, newScore, elementBuffer.array());
                    continue;
                }
                if (!ZParams.Aggregate.MAX.name().equals(typeOfAggregation)) continue;
                this.zincrmax(dstkey, newScore, elementBuffer.array());
            }
        }
    }

    private Double zincrmax(byte[] key, double score, byte[] member) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        ScoredByteBuffer memberToUpdate = this.findScoredByteBufferByKeyAndMember(member, wrappedKey);
        if (memberToUpdate != null) {
            double newScore = memberToUpdate.getScore() < score ? score : memberToUpdate.getScore();
            this.removeAndUpdateElement(newScore, member, wrappedKey, memberToUpdate);
            return newScore;
        }
        this.sortset.put((Object)wrappedKey, (Object)ScoredByteBuffer.createScoredByteBuffer(ByteBuffer.wrap(member), score));
        return score;
    }

    private Double zincrmin(byte[] key, double score, byte[] member) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        ScoredByteBuffer memberToUpdate = this.findScoredByteBufferByKeyAndMember(member, wrappedKey);
        if (memberToUpdate != null) {
            double newScore = memberToUpdate.getScore() > score ? score : memberToUpdate.getScore();
            this.removeAndUpdateElement(newScore, member, wrappedKey, memberToUpdate);
            return newScore;
        }
        this.sortset.put((Object)wrappedKey, (Object)ScoredByteBuffer.createScoredByteBuffer(ByteBuffer.wrap(member), score));
        return score;
    }

    private int multiplicationFactor(List<ByteBuffer> weightValues, int index) {
        if (weightValues.size() == 0) {
            return 1;
        }
        return Integer.parseInt(SafeEncoder.encode((byte[])weightValues.get(index).array()));
    }

    private boolean areWeightValuesCorrectlySet(List<ByteBuffer> weightValues, byte[] ... sets) {
        return weightValues.size() == 0 || weightValues.size() == sets.length;
    }

    private List<ByteBuffer> getWeightValues(List<ByteBuffer> parameters) {
        if (parameters.contains(ByteBuffer.wrap(Protocol.Keyword.WEIGHTS.raw))) {
            int weightsWordIndex = parameters.indexOf(ByteBuffer.wrap(Protocol.Keyword.WEIGHTS.raw));
            parameters.remove(weightsWordIndex);
            return parameters;
        }
        return Collections.EMPTY_LIST;
    }

    private String getTypeOfAggregationAndRemoveFromAggregationParameters(List<ByteBuffer> parameters) {
        String typeOfAggregation = ZParams.Aggregate.SUM.name();
        if (parameters.contains(ByteBuffer.wrap(Protocol.Keyword.AGGREGATE.raw))) {
            int aggregateWordIndex = parameters.indexOf(ByteBuffer.wrap(Protocol.Keyword.AGGREGATE.raw));
            typeOfAggregation = SafeEncoder.encode((byte[])parameters.get(aggregateWordIndex + 1).array());
            parameters.remove(aggregateWordIndex);
            parameters.remove(aggregateWordIndex);
        }
        return typeOfAggregation;
    }

    protected Set<ByteBuffer> unionElements(List<byte[]> keys) {
        HashSet unionElements = new HashSet();
        for (byte[] key : keys) {
            unionElements.addAll(this.sortset.get((Object)ByteBuffer.wrap(key)));
        }
        return new HashSet<ByteBuffer>(Lambda.extract(unionElements, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer()));
    }

    protected Set<ByteBuffer> intersactionElements(List<byte[]> keys) {
        if (keys.size() == 0) {
            return new HashSet<ByteBuffer>();
        }
        Set<ByteBuffer> targetKey = new HashSet<ByteBuffer>(this.getReferenceElement(keys));
        targetKey = this.retainElements(targetKey, keys);
        return targetKey;
    }

    private Set<ByteBuffer> retainElements(Set<ByteBuffer> targetKey, List<byte[]> keys) {
        for (int index = 1; index < keys.size(); ++index) {
            Collection collectionElements = this.sortset.get((Object)ByteBuffer.wrap(keys.get(index)));
            List extract = Lambda.extract((Object)collectionElements, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer());
            targetKey.retainAll(extract);
        }
        return targetKey;
    }

    private List<ByteBuffer> getReferenceElement(List<byte[]> keys) {
        Collection referenceElements = this.sortset.get((Object)ByteBuffer.wrap(keys.get(0)));
        return Lambda.extract((Object)referenceElements, (Object)((ScoredByteBuffer)Lambda.on(ScoredByteBuffer.class)).getByteBuffer());
    }

    @Override
    public Long del(byte[] ... keys) {
        long numberOfRemovedElements = 0L;
        for (byte[] key : keys) {
            ByteBuffer wrappedKey = ByteBuffer.wrap(key);
            if (!this.sortset.containsKey((Object)wrappedKey)) continue;
            this.sortset.removeAll((Object)wrappedKey);
            this.removeExpiration(key);
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    @Override
    public boolean exists(byte[] key) {
        return this.sortset.containsKey((Object)ByteBuffer.wrap(key));
    }

    @Override
    public boolean renameKey(byte[] key, byte[] newKey) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.sortset.containsKey((Object)wrappedKey)) {
            Collection elements = this.sortset.get((Object)wrappedKey);
            this.sortset.removeAll((Object)ByteBuffer.wrap(newKey));
            this.sortset.putAll((Object)ByteBuffer.wrap(newKey), (Iterable)elements);
            this.sortset.removeAll((Object)wrappedKey);
            this.renameTtlKey(key, newKey);
            return true;
        }
        return false;
    }

    @Override
    public List<byte[]> keys() {
        return new ArrayList<byte[]>(Lambda.convert((Object)this.sortset.keySet(), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public String type() {
        return ZSET;
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        try {
            return this.sortNumberValues(key);
        }
        catch (NumberFormatException e) {
            Collection scoredElements = this.sortset.get((Object)ByteBuffer.wrap(key));
            List elements = Lambda.convert((Object)scoredElements, (Converter)ScoredByteBufferToByteBuffer.createScoredByteBufferToByteBufferConverter());
            return Lambda.convert((Object)elements, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        }
    }

    private List<byte[]> sortNumberValues(byte[] key) {
        Collection scoredElements = this.sortset.get((Object)ByteBuffer.wrap(key));
        List elements = Lambda.convert((Object)scoredElements, (Converter)ScoredByteBufferToByteBuffer.createScoredByteBufferToByteBufferConverter());
        List values = Lambda.convert((Object)elements, (Converter)ByteBufferAsString2DoubleConverter.createByteBufferAsStringToDoubleConverter());
        Collections.sort(values);
        return new LinkedList<byte[]>(Lambda.convert((Object)values, (Converter)DoubleToStringByteArrayConverter.createDoubleToStringByteArrayConverter()));
    }

    private static class ScoredByteBufferToByteBuffer
    implements Converter<ScoredByteBuffer, ByteBuffer> {
        private ScoredByteBufferToByteBuffer() {
        }

        private static ScoredByteBufferToByteBuffer createScoredByteBufferToByteBufferConverter() {
            return new ScoredByteBufferToByteBuffer();
        }

        public ByteBuffer convert(ScoredByteBuffer from) {
            return from.getByteBuffer();
        }
    }

    protected static class ScoredByteBuffer
    implements Comparable<ScoredByteBuffer> {
        private double score;
        private ByteBuffer byteBuffer;

        private ScoredByteBuffer(ByteBuffer byteBuffer, double score) {
            this.score = score;
            this.byteBuffer = byteBuffer;
        }

        public static ScoredByteBuffer createScoredByteBuffer(ByteBuffer byteBuffer, double score) {
            return new ScoredByteBuffer(byteBuffer, score);
        }

        public double getScore() {
            return this.score;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        @Override
        public int compareTo(ScoredByteBuffer scoredByteBuffer) {
            if (this.score == scoredByteBuffer.getScore()) {
                return this.byteBuffer.compareTo(scoredByteBuffer.getByteBuffer());
            }
            if (this.score > scoredByteBuffer.getScore()) {
                return 1;
            }
            return -1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.byteBuffer == null ? 0 : this.byteBuffer.hashCode());
            long temp = Double.doubleToLongBits(this.score);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScoredByteBuffer other = (ScoredByteBuffer)obj;
            if (this.byteBuffer == null ? other.byteBuffer != null : !this.byteBuffer.equals(other.byteBuffer)) {
                return false;
            }
            return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
        }

        public String toString() {
            return new String(this.byteBuffer.array()) + " - " + this.score;
        }
    }
}

