/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaCollections;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBuffer2ByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBufferAsString2DoubleConverter;
import com.lordofthejars.nosqlunit.redis.embedded.DoubleToStringByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class SetDatatypeOperations
extends ExpirationDatatypeOperations
implements RedisDatatypeOperations {
    protected static final String SET = "set";
    private static final Random random = new Random();
    protected Multimap<ByteBuffer, ByteBuffer> setElements = HashMultimap.create();

    public Long sadd(byte[] key, byte[] ... members) {
        long numberOfAddedElements = 0L;
        for (byte[] bs : members) {
            if (!this.setElements.put((Object)ByteBuffer.wrap(key), (Object)ByteBuffer.wrap(bs))) continue;
            ++numberOfAddedElements;
        }
        return numberOfAddedElements;
    }

    public Long scard(byte[] key) {
        ByteBuffer keyBuffer = ByteBuffer.wrap(key);
        return this.setElements.get((Object)keyBuffer).size();
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        Set<ByteBuffer> targetKey = this.differenceElements(keys);
        List diff = Lambda.convert(targetKey, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        return new HashSet<byte[]>(diff);
    }

    private Set<ByteBuffer> differenceElements(byte[] ... keys) {
        if (keys.length == 0) {
            return new HashSet<ByteBuffer>();
        }
        Set<ByteBuffer> targetKey = new HashSet<ByteBuffer>(this.getReferenceElement(keys));
        targetKey = this.removeElements(targetKey, keys);
        return targetKey;
    }

    private Set<ByteBuffer> removeElements(Set<ByteBuffer> targetKey, byte[] ... keys) {
        for (int index = 1; index < keys.length; ++index) {
            Collection collectionElements = this.setElements.get((Object)ByteBuffer.wrap(keys[index]));
            targetKey.removeAll(collectionElements);
        }
        return targetKey;
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        Set<ByteBuffer> sdiff = this.differenceElements(keys);
        this.setElements.replaceValues((Object)ByteBuffer.wrap(dstkey), sdiff);
        return sdiff.size();
    }

    private void removeAllValues(byte[] dstkey) {
        this.setElements.removeAll((Object)ByteBuffer.wrap(dstkey));
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        Set<ByteBuffer> targetKey = this.intersactionElements(keys);
        List intersaction = Lambda.convert(targetKey, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        return new HashSet<byte[]>(intersaction);
    }

    private Set<ByteBuffer> intersactionElements(byte[] ... keys) {
        if (keys.length == 0) {
            return new HashSet<ByteBuffer>();
        }
        Set<ByteBuffer> targetKey = new HashSet<ByteBuffer>(this.getReferenceElement(keys));
        targetKey = this.retainElements(targetKey, keys);
        return targetKey;
    }

    private Set<ByteBuffer> retainElements(Set<ByteBuffer> targetKey, byte[] ... keys) {
        for (int index = 1; index < keys.length; ++index) {
            Collection collectionElements = this.setElements.get((Object)ByteBuffer.wrap(keys[index]));
            targetKey.retainAll(collectionElements);
        }
        return targetKey;
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        Set<ByteBuffer> sintersect = this.intersactionElements(keys);
        this.setElements.replaceValues((Object)ByteBuffer.wrap(dstkey), sintersect);
        return sintersect.size();
    }

    public Boolean sismember(byte[] key, byte[] member) {
        Collection elements = this.setElements.get((Object)ByteBuffer.wrap(key));
        return LambdaCollections.with((Collection)elements).contains((Object)ByteBuffer.wrap(member));
    }

    public Set<byte[]> smembers(byte[] key) {
        Collection elements = this.setElements.get((Object)ByteBuffer.wrap(key));
        List allElements = Lambda.convert((Object)elements, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        return new HashSet<byte[]>(allElements);
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        boolean isElementPresent = this.sismember(srckey, member);
        if (isElementPresent) {
            this.removeElement(srckey, member);
            this.sadd(dstkey, new byte[][]{member});
            return 1L;
        }
        return 0L;
    }

    public byte[] spop(byte[] key) {
        byte[] removedElement = this.srandmember(key);
        if (removedElement != null) {
            return this.removeElement(key, removedElement);
        }
        return null;
    }

    public byte[] srandmember(byte[] key) {
        Set<byte[]> elements = this.smembers(key);
        if (elements.size() > 0) {
            int randomPosition = this.randomInteger(elements.size());
            return this.elementInPosition(elements, randomPosition);
        }
        return null;
    }

    public Long srem(byte[] key, byte[] ... members) {
        long numberOfRemovedElements = 0L;
        for (byte[] member : members) {
            if (this.removeElement(key, member) == null) continue;
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        Set<ByteBuffer> unionElements = this.unionElements(keys);
        List allElements = Lambda.convert(unionElements, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        return new HashSet<byte[]>(allElements);
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        Set<ByteBuffer> sunion = this.unionElements(keys);
        this.setElements.replaceValues((Object)ByteBuffer.wrap(dstkey), sunion);
        return sunion.size();
    }

    @Override
    public long getNumberOfKeys() {
        return this.setElements.keySet().size();
    }

    @Override
    public void flushAllKeys() {
        this.removeExpirations();
        this.setElements.clear();
    }

    private void removeExpirations() {
        List<byte[]> keys = this.keys();
        for (byte[] key : keys) {
            this.removeExpiration(key);
        }
    }

    private Collection<ByteBuffer> getReferenceElement(byte[] ... keys) {
        return this.setElements.get((Object)ByteBuffer.wrap(keys[0]));
    }

    private Set<ByteBuffer> unionElements(byte[] ... keys) {
        HashSet<ByteBuffer> unionElements = new HashSet<ByteBuffer>();
        for (byte[] key : keys) {
            unionElements.addAll(this.setElements.get((Object)ByteBuffer.wrap(key)));
        }
        return unionElements;
    }

    private byte[] removeElement(byte[] srckey, byte[] member) {
        Collection elements = this.setElements.get((Object)ByteBuffer.wrap(srckey));
        boolean isRemoved = elements.remove(ByteBuffer.wrap(member));
        return (byte[])(isRemoved ? member : null);
    }

    private int randomInteger(int n) {
        return random.nextInt(n);
    }

    private byte[] elementInPosition(Collection<byte[]> elements, int position) {
        int currentPosition = 0;
        for (byte[] element : elements) {
            if (currentPosition == position) {
                return element;
            }
            ++currentPosition;
        }
        return null;
    }

    @Override
    public Long del(byte[] ... keys) {
        long numberOfRemovedElements = 0L;
        for (byte[] key : keys) {
            ByteBuffer wrappedKey = ByteBuffer.wrap(key);
            if (!this.setElements.containsKey((Object)wrappedKey)) continue;
            this.setElements.removeAll((Object)wrappedKey);
            this.removeExpiration(key);
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    @Override
    public boolean exists(byte[] key) {
        return this.setElements.containsKey((Object)ByteBuffer.wrap(key));
    }

    @Override
    public boolean renameKey(byte[] key, byte[] newKey) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.setElements.containsKey((Object)wrappedKey)) {
            Collection elements = this.setElements.get((Object)wrappedKey);
            this.setElements.removeAll((Object)ByteBuffer.wrap(newKey));
            this.setElements.putAll((Object)ByteBuffer.wrap(newKey), (Iterable)elements);
            this.setElements.removeAll((Object)wrappedKey);
            this.renameTtlKey(key, newKey);
            return true;
        }
        return false;
    }

    @Override
    public List<byte[]> keys() {
        return new ArrayList<byte[]>(Lambda.convert((Object)this.setElements.keySet(), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public String type() {
        return SET;
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        try {
            return this.sortNumberValues(key);
        }
        catch (NumberFormatException e) {
            return Lambda.convert((Object)this.setElements.get((Object)ByteBuffer.wrap(key)), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        }
    }

    private List<byte[]> sortNumberValues(byte[] key) {
        Collection elements = this.setElements.get((Object)ByteBuffer.wrap(key));
        List values = Lambda.convert((Object)elements, (Converter)ByteBufferAsString2DoubleConverter.createByteBufferAsStringToDoubleConverter());
        Collections.sort(values);
        return new LinkedList<byte[]>(Lambda.convert((Object)values, (Converter)DoubleToStringByteArrayConverter.createDoubleToStringByteArrayConverter()));
    }
}

