/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteArrayToStringConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.MatchesGlobRegexpMatcher;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.StringToByteArrayConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.JedisMonitor;
import redis.clients.util.SafeEncoder;
import redis.clients.util.Slowlog;

public class KeysServerOperations {
    protected static final String NONE = "none";
    private static final String OK = "OK";
    private static final String KO = "-";
    private List<RedisDatatypeOperations> redisDatatypeOperations;

    private KeysServerOperations() {
    }

    public static KeysServerOperations createKeysServerOperations(RedisDatatypeOperations ... redisDatatypeOperations) {
        KeysServerOperations keysServerOperations = new KeysServerOperations();
        keysServerOperations.redisDatatypeOperations = Arrays.asList(redisDatatypeOperations);
        return keysServerOperations;
    }

    public Long dbSize() {
        long numberOfKeys = 0L;
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            numberOfKeys += redisDatatypeOperations.getNumberOfKeys();
        }
        return numberOfKeys;
    }

    public String flushAll() {
        return this.flushDB();
    }

    public String flushDB() {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            redisDatatypeOperations.flushAllKeys();
        }
        return OK;
    }

    public Long del(byte[] ... keys) {
        long numberOfRemovedelements = 0L;
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            numberOfRemovedelements += redisDatatypeOperations.del(keys).longValue();
        }
        return numberOfRemovedelements;
    }

    public Boolean exists(byte[] key) {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            if (!redisDatatypeOperations.exists(key)) continue;
            return true;
        }
        return false;
    }

    private RedisDatatypeOperations whereIsKey(byte[] key) {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            if (!redisDatatypeOperations.exists(key)) continue;
            return redisDatatypeOperations;
        }
        return null;
    }

    public String rename(byte[] oldKey, byte[] newKey) {
        if (Arrays.equals(oldKey, newKey)) {
            return KO;
        }
        if (this.exists(oldKey).booleanValue()) {
            RedisDatatypeOperations newKeyRepository = this.whereIsKey(newKey);
            if (newKeyRepository != null) {
                newKeyRepository.del(new byte[][]{newKey});
            }
            RedisDatatypeOperations oldKeyRepository = this.whereIsKey(oldKey);
            oldKeyRepository.renameKey(oldKey, newKey);
            return OK;
        }
        return KO;
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        if (!this.exists(newkey).booleanValue()) {
            this.rename(oldkey, newkey);
            return 1L;
        }
        return 0L;
    }

    public Long expire(byte[] key, int seconds) {
        RedisDatatypeOperations redisOperation = this.whereIsKey(key);
        if (redisOperation != null) {
            redisOperation.addExpirationTime(key, seconds, TimeUnit.SECONDS);
            return 1L;
        }
        return 0L;
    }

    public Long expireAt(byte[] key, long unixTime) {
        RedisDatatypeOperations redisOperation = this.whereIsKey(key);
        if (redisOperation != null) {
            redisOperation.addExpirationAt(key, unixTime, TimeUnit.SECONDS);
            return 1L;
        }
        return 0L;
    }

    public Set<byte[]> keys(byte[] patternbyte) {
        String pattern = SafeEncoder.encode((byte[])patternbyte);
        ArrayList stringKeys = new ArrayList();
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            stringKeys.addAll(Lambda.convert(redisDatatypeOperations.keys(), (Converter)ByteArrayToStringConverter.createByteArrayToStringConverter()));
        }
        List filteredKeys = Lambda.filter(MatchesGlobRegexpMatcher.matches(pattern), stringKeys);
        return new HashSet<byte[]>(Lambda.convert((Object)filteredKeys, (Converter)StringToByteArrayConverter.createStringToByteArrayConverter()));
    }

    public Long persist(byte[] key) {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            if (!redisDatatypeOperations.removeExpiration(key)) continue;
            return 1L;
        }
        return 0L;
    }

    public Long ttl(byte[] key) {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            long ttlTime = redisDatatypeOperations.remainingTime(key);
            if (ttlTime == ExpirationDatatypeOperations.NO_EXPIRATION) continue;
            return ttlTime;
        }
        return ExpirationDatatypeOperations.NO_EXPIRATION;
    }

    public String type(byte[] key) {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            if (!redisDatatypeOperations.exists(key)) continue;
            return redisDatatypeOperations.type();
        }
        return NONE;
    }

    public List<byte[]> sort(byte[] key) {
        if (this.type(key).equals("hash") || this.type(key).equals("string")) {
            throw new UnsupportedOperationException("ERR Operation against a key holding the wrong kind of value");
        }
        RedisDatatypeOperations datastoreWithKey = this.whereIsKey(key);
        if (datastoreWithKey != null) {
            return datastoreWithKey.sort(key);
        }
        return Collections.EMPTY_LIST;
    }

    public void updateTtl() {
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            List<byte[]> keys = redisDatatypeOperations.keys();
            for (byte[] key : keys) {
                this.updateTtl(key);
            }
        }
    }

    public void updateTtl(byte[] key) {
        ExpirationDatatypeOperations.TtlState ttlState;
        RedisDatatypeOperations datastore = this.whereIsKey(key);
        if (datastore != null && (ttlState = datastore.timedoutState(key)) == ExpirationDatatypeOperations.TtlState.EXPIRED) {
            this.del(new byte[][]{key});
        }
    }

    public Long move(byte[] key, int dbIndex) {
        return 1L;
    }

    public Long objectRefcount(byte[] string) {
        throw new UnsupportedOperationException("Object Ref is not supported.");
    }

    public byte[] objectEncoding(byte[] string) {
        throw new UnsupportedOperationException("Object Encoding is not supported.");
    }

    public Long objectIdletime(byte[] string) {
        throw new UnsupportedOperationException("Object Idel is not supported.");
    }

    public byte[] randomKey() {
        ArrayList<byte[]> allKeys = new ArrayList<byte[]>();
        for (RedisDatatypeOperations redisDatatypeOperations : this.redisDatatypeOperations) {
            allKeys.addAll(redisDatatypeOperations.keys());
        }
        if (allKeys.size() > 0) {
            int randomIndex = this.generateRandomIndex(allKeys);
            return (byte[])allKeys.get(randomIndex);
        }
        return null;
    }

    public String bgrewriteaof() {
        return OK;
    }

    public String save() {
        return OK;
    }

    public String bgsave() {
        return OK;
    }

    public List<byte[]> configGet(byte[] pattern) {
        return new ArrayList<byte[]>();
    }

    public byte[] configSet(byte[] parameter, byte[] value) {
        return OK.getBytes();
    }

    public String configResetStat() {
        return OK;
    }

    public String info() {
        return "Embedded Jedis";
    }

    public Long lastsave() {
        return System.currentTimeMillis();
    }

    public void monitor(JedisMonitor jedisMonitor) {
    }

    public String shutdown() {
        return OK;
    }

    public String slaveof(String host, int port) {
        return OK;
    }

    public String slaveofNoOne() {
        return OK;
    }

    public List<Slowlog> slowlogGet() {
        return new ArrayList<Slowlog>();
    }

    public List<Slowlog> slowlogGet(long entries) {
        return new ArrayList<Slowlog>();
    }

    public byte[] slowlogReset() {
        return OK.getBytes();
    }

    public long slowlogLen() {
        return 0L;
    }

    public List<byte[]> slowlogGetBinary() {
        return new ArrayList<byte[]>();
    }

    public List<byte[]> slowlogGetBinary(long entries) {
        return new ArrayList<byte[]>();
    }

    public void sync() {
    }

    public Long time() {
        return System.currentTimeMillis();
    }

    public Long getDB() {
        return 0L;
    }

    public boolean isConnected() {
        return true;
    }

    private int generateRandomIndex(List<byte[]> allKeys) {
        Random random = new Random();
        int randomIndex = random.nextInt(allKeys.size());
        return randomIndex;
    }
}

