/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class ExpirationDatatypeOperations {
    public static final Long NO_EXPIRATION = -1L;
    protected Map<ByteBuffer, Long> expirationsInMillis = new HashMap<ByteBuffer, Long>();

    public long remainingTime(byte[] key) {
        if (this.timedoutState(key) == TtlState.NOT_EXPIRED) {
            Long expirationTime = this.expirationsInMillis.get(ByteBuffer.wrap(key));
            return TimeUnit.SECONDS.convert(expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        return -1L;
    }

    public void addExpirationTime(byte[] key, long duration, TimeUnit unit) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        long durationInMillis = unit.toMillis(duration);
        this.expirationsInMillis.put(wrappedKey, System.currentTimeMillis() + durationInMillis);
    }

    public void addExpirationAt(byte[] key, long time, TimeUnit unit) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        long timeInMillis = unit.toMillis(time);
        this.expirationsInMillis.put(wrappedKey, timeInMillis);
    }

    public TtlState timedoutState(byte[] key) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.expirationsInMillis.containsKey(wrappedKey)) {
            Long ttl = this.expirationsInMillis.get(wrappedKey);
            if (NO_EXPIRATION == ttl) {
                return TtlState.NOT_MANAGED;
            }
            boolean isExpired = System.currentTimeMillis() > ttl;
            return isExpired ? TtlState.EXPIRED : TtlState.NOT_EXPIRED;
        }
        return TtlState.NOT_MANAGED;
    }

    public boolean removeExpiration(byte[] key) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.expirationsInMillis.containsKey(wrappedKey)) {
            this.expirationsInMillis.remove(wrappedKey);
            return true;
        }
        return false;
    }

    public void renameTtlKey(byte[] oldKey, byte[] newKey) {
        ByteBuffer wrappedOldKey = ByteBuffer.wrap(oldKey);
        if (this.expirationsInMillis.containsKey(wrappedOldKey)) {
            Long ttl = this.expirationsInMillis.get(wrappedOldKey);
            this.expirationsInMillis.put(ByteBuffer.wrap(newKey), ttl);
            this.expirationsInMillis.remove(wrappedOldKey);
        }
    }

    public static enum TtlState {
        EXPIRED,
        NOT_EXPIRED,
        NOT_MANAGED;

    }
}

