/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.redis.EmbeddedRedisLifecycleManager;
import org.junit.rules.ExternalResource;

public class EmbeddedRedis
extends ExternalResource {
    protected EmbeddedRedisLifecycleManager embeddedRedisLifecycleManager;

    private EmbeddedRedis() {
    }

    protected void before() throws Throwable {
        this.embeddedRedisLifecycleManager.startEngine();
    }

    protected void after() {
        this.embeddedRedisLifecycleManager.stopEngine();
    }

    public static class EmbeddedRedisRuleBuilder {
        private EmbeddedRedisLifecycleManager embeddedRedisLifecycleManager = new EmbeddedRedisLifecycleManager();

        private EmbeddedRedisRuleBuilder() {
        }

        public static EmbeddedRedisRuleBuilder newEmbeddedRedisRule() {
            return new EmbeddedRedisRuleBuilder();
        }

        public EmbeddedRedisRuleBuilder targetPath(String targetPath) {
            this.embeddedRedisLifecycleManager.setTargetPath(targetPath);
            return this;
        }

        public EmbeddedRedis build() {
            if (this.embeddedRedisLifecycleManager.getTargetPath() == null) {
                throw new IllegalArgumentException("No Path to Embedded Redis is provided.");
            }
            EmbeddedRedis embeddedRedis = new EmbeddedRedis();
            embeddedRedis.embeddedRedisLifecycleManager = this.embeddedRedisLifecycleManager;
            return embeddedRedis;
        }
    }
}

