/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.richfaces.component.AbstractPoll;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.HandlersChain;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="poll.js")})
public class AjaxPollRenderer
extends RendererBase {
    public static final String COMPONENT_FAMILY = "org.richfaces.Poll";
    public static final String RENDERER_TYPE = "org.richfaces.PollRenderer";
    private static final String AJAX_POLL_FUNCTION = "new RichFaces.ui.Poll";
    private static final String ENABLED = "enabled";

    private void addComponentToAjaxRender(FacesContext context, UIComponent component) {
        PartialViewContext pvc = context.getPartialViewContext();
        pvc.getRenderIds().add(component.getClientId(context));
    }

    @Override
    protected void queueComponentEventForBehaviorEvent(FacesContext context, UIComponent component, String eventName) {
        super.queueComponentEventForBehaviorEvent(context, component, eventName);
        if ("timer".equals(eventName)) {
            new ActionEvent(component).queue();
            this.addComponentToAjaxRender(context, component);
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        RendererUtils utils = this.getUtils();
        boolean shouldRenderForm = utils.getNestingForm(component) == null;
        String rootElementName = shouldRenderForm ? "div" : "span";
        AbstractPoll poll = (AbstractPoll)component;
        writer.startElement(rootElementName, component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        utils.encodeId(context, component);
        if (shouldRenderForm) {
            String clientId = component.getClientId(context) + ":_form";
            utils.encodeBeginForm(context, component, writer, clientId);
            utils.encodeEndForm(context, writer);
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("");
        JSFunction function = new JSFunction(AJAX_POLL_FUNCTION, new Object[0]);
        HashMap<String, Object> options = new HashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "interval", poll.getInterval(), "1000");
        HandlersChain handlersChain = new HandlersChain(context, (UIComponent)poll);
        handlersChain.addInlineHandlerFromAttribute("ontimer");
        handlersChain.addBehaviors("timer");
        handlersChain.addAjaxSubmitFunction();
        String handler = handlersChain.toScript();
        if (handler != null) {
            JSFunctionDefinition timerHandler = new JSFunctionDefinition(new Object[]{JSReference.EVENT});
            timerHandler.addToBody((Object)handler);
            options.put("ontimer", timerHandler);
        }
        if (poll.isEnabled()) {
            options.put(ENABLED, true);
        }
        function.addParameter((Object)component.getClientId(context));
        function.addParameter(options);
        writer.writeText((Object)function.toScript(), null);
        writer.endElement("script");
        writer.endElement(rootElementName);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPoll.class;
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        super.doDecode(context, component);
        AbstractPoll poll = (AbstractPoll)component;
        if (poll.isEnabled() && (requestParameterMap = context.getExternalContext().getRequestParameterMap()).get(poll.getClientId(context)) != null) {
            new ActionEvent((UIComponent)poll).queue();
            this.addComponentToAjaxRender(context, component);
        }
    }
}

