/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.ecm.directory.multi.MultiDirectoryFactory;
import org.nuxeo.ecm.directory.multi.MultiDirectorySession;
import org.nuxeo.ecm.directory.multi.MultiReference;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;

public class MultiDirectory
extends AbstractDirectory {
    private final MultiDirectoryDescriptor descriptor;

    public MultiDirectory(MultiDirectoryDescriptor descriptor) {
        super(descriptor.name);
        this.descriptor = descriptor;
    }

    protected MultiDirectoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.name;
    }

    public String getSchema() {
        return this.descriptor.schemaName;
    }

    public String getParentDirectory() {
        return null;
    }

    public String getIdField() {
        return this.descriptor.idField;
    }

    public String getPasswordField() {
        return this.descriptor.passwordField;
    }

    public Session getSession() throws DirectoryException {
        MultiDirectorySession session = new MultiDirectorySession(this);
        this.addSession((Session)session);
        return session;
    }

    public Reference getReference(String referenceFieldName) {
        return new MultiReference(this, referenceFieldName);
    }

    public void invalidateDirectoryCache() throws DirectoryException {
        this.getCache().invalidateAll();
        for (SourceDescriptor src : this.descriptor.sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                Directory dir = MultiDirectoryFactory.getDirectoryService().getDirectory(sub.name);
                if (dir == null) continue;
                dir.invalidateDirectoryCache();
            }
        }
    }
}

