/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app.jersey;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.jaxrs.Activator;
import org.nuxeo.ecm.webengine.jaxrs.servlet.ApplicationServlet;

public class WebEngineServlet
extends ApplicationServlet {
    protected final String MIME_TYPE = "X-File-Type";
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        this.bundle = Activator.getInstance().getContext().getBundle();
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.containerService(request, response);
    }

    protected void containerService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean patchMMType;
        String method;
        if (this.isDirty) {
            this.reloadContainer();
        }
        if (!"GET".equals(method = request.getMethod().toUpperCase())) {
            request.getParameterMap();
        }
        String ctype = request.getHeader("Content-Type");
        String mtype = request.getHeader("X-File-Type");
        boolean patchCType = ctype == null || ctype.length() == 0 || !ctype.contains("/");
        boolean bl = patchMMType = mtype != null && !mtype.contains("/");
        if (patchCType || patchMMType) {
            request = new DefaultContentTypeRequestWrapper((HttpServletRequest)request, patchCType, patchMMType);
        }
        this.container.service(request, response);
    }

    private final class DefaultContentTypeRequestWrapper
    extends HttpServletRequestWrapper {
        protected final Hashtable<String, String[]> headers;
        protected final String lCONTENT_TYPE;
        protected final String lFILE_TYPE;

        protected DefaultContentTypeRequestWrapper(HttpServletRequest request, boolean patchCType, boolean patchMType) {
            super(request);
            this.lCONTENT_TYPE = "Content-Type".toLowerCase();
            this.lFILE_TYPE = "X-File-Type".toLowerCase();
            this.headers = this.patchHeaders(request, patchCType, patchMType);
        }

        protected Hashtable<String, String[]> patchHeaders(HttpServletRequest request, boolean patchCType, boolean patchMType) {
            Hashtable<String, String[]> headers = new Hashtable<String, String[]>();
            Enumeration eachNames = request.getHeaderNames();
            while (eachNames.hasMoreElements()) {
                String name = ((String)eachNames.nextElement()).toLowerCase();
                LinkedList values = new LinkedList();
                Enumeration eachValues = request.getHeaders(name);
                while (eachValues.hasMoreElements()) {
                    values.add(eachValues.nextElement());
                }
                headers.put(name, values.toArray(new String[values.size()]));
            }
            if (patchCType) {
                String ctype = request.getContentType();
                if (ctype == null || ctype.isEmpty()) {
                    String[] ctypes = new String[]{"application/octet-stream"};
                    headers.put(this.lCONTENT_TYPE, ctypes);
                } else {
                    this.patchContentTypes(headers.get(this.lCONTENT_TYPE));
                }
            }
            if (patchMType) {
                this.patchContentTypes(headers.get(this.lFILE_TYPE));
            }
            return headers;
        }

        protected void patchContentTypes(String[] ctypes) {
            for (int index = 0; index < ctypes.length; ++index) {
                String value = ctypes[index];
                if (value.isEmpty()) {
                    ctypes[index] = "application/octet-stream";
                    continue;
                }
                if (value.contains("/")) continue;
                ctypes[index] = "application/".concat(value);
            }
        }

        public Enumeration<String> getHeaderNames() {
            return this.headers.keys();
        }

        public String getHeader(String name) {
            String lname = name.toLowerCase();
            if (!this.headers.containsKey(lname)) {
                return null;
            }
            return this.headers.get(lname)[0];
        }

        public Enumeration<String> getHeaders(String name) {
            final String lname = name.toLowerCase();
            if (!this.headers.containsKey(lname)) {
                return Collections.emptyEnumeration();
            }
            return new Enumeration<String>(){
                String[] values;
                int index;
                {
                    this.values = DefaultContentTypeRequestWrapper.this.headers.get(lname);
                    this.index = 0;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.index < this.values.length;
                }

                @Override
                public String nextElement() {
                    if (this.index >= this.values.length) {
                        throw new NoSuchElementException(this.index + " is higher than " + this.values.length);
                    }
                    return this.values[this.index++];
                }
            };
        }
    }
}

