/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.app.WebEngineModule;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class WebEngineModuleFactory {
    public static Log log = LogFactory.getLog(WebEngineModuleFactory.class);

    public static Bundle[] getFragments(Bundle bundle) {
        BundleContext context = bundle.getBundleContext();
        ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin admin = (PackageAdmin)context.getService(ref);
        return admin.getFragments(bundle);
    }

    public static WebEngineModule getApplication(WebEngineModule app, Bundle bundle, Map<String, String> attrs) throws Exception {
        Bundle[] fragments;
        WebEngine engine = (WebEngine)Framework.getLocalService(WebEngine.class);
        boolean explode = true;
        if (attrs != null && "false".equals(attrs.get("explode"))) {
            explode = false;
        }
        File moduleDir = WebEngineModuleFactory.locateModuleDir(bundle, engine, explode);
        app.init(engine, bundle, new File(moduleDir, "module.xml"), attrs);
        app.cfg.directory = moduleDir;
        for (Bundle fragment : fragments = WebEngineModuleFactory.getFragments(bundle)) {
            File fragmentDir = WebEngineModuleFactory.locateModuleDir(fragment, engine, explode);
            app.cfg.fragmentDirectories.add(fragmentDir);
        }
        app.cfg.allowHostOverride = Boolean.parseBoolean((String)bundle.getHeaders().get("Nuxeo-AllowOverride"));
        engine.addApplication(app);
        log.info((Object)("Deployed web module found in bundle: " + bundle.getSymbolicName()));
        return app;
    }

    private static File locateModuleDir(Bundle bundle, WebEngine engine, boolean explode) throws IOException {
        File moduleDir = null;
        File bundleFile = Framework.getRuntime().getBundleFile(bundle);
        if (explode) {
            moduleDir = WebEngineModuleFactory.explodeBundle(engine, bundle, bundleFile);
        } else if (bundleFile.isDirectory()) {
            moduleDir = bundleFile;
        }
        return moduleDir;
    }

    private static File explodeBundle(WebEngine engine, Bundle bundle, File bundleFile) throws IOException {
        if (bundleFile.isDirectory()) {
            return bundleFile;
        }
        File moduleRoot = new File(engine.getRootDirectory(), "modules/" + bundle.getSymbolicName());
        if (moduleRoot.exists()) {
            if (bundleFile.lastModified() < moduleRoot.lastModified()) {
                return moduleRoot;
            }
            FileUtils.deleteTree((File)moduleRoot);
        }
        moduleRoot.mkdirs();
        ZipUtils.unzip((File)bundleFile, (File)moduleRoot, (PathFilter)new PathFilter(){

            public boolean isExclusive() {
                return false;
            }

            public boolean accept(Path arg0) {
                return !arg0.lastSegment().endsWith(".class");
            }
        });
        return moduleRoot;
    }
}

