/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NoRollbackOnException;
import org.nuxeo.runtime.api.J2EEContainerDescriptor;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionalCoreSessionWrapper
implements InvocationHandler,
Synchronization {
    private static final Log log = LogFactory.getLog(TransactionalCoreSessionWrapper.class);
    private static final Class<?>[] INTERFACES = new Class[]{CoreSession.class};
    private final CoreSession session;
    private final ThreadLocal<Transaction> threadBound = new ThreadLocal();

    protected TransactionalCoreSessionWrapper(CoreSession session) {
        this.session = session;
    }

    public static CoreSession wrap(CoreSession session) {
        try {
            TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            return session;
        }
        ClassLoader cl = session.getClass().getClassLoader();
        return (CoreSession)Proxy.newProxyInstance(cl, INTERFACES, (InvocationHandler)new TransactionalCoreSessionWrapper(session));
    }

    protected void checkTxActiveRequired(Method m) {
        if (this.threadBound.get() != null) {
            return;
        }
        if (J2EEContainerDescriptor.getSelected() == null) {
            return;
        }
        String name = m.getName();
        if ("getSessionId".equals(name)) {
            return;
        }
        if ("connect".equals(name)) {
            return;
        }
        if ("close".equals(name)) {
            return;
        }
        if ("destroy".equals(name)) {
            return;
        }
        log.warn((Object)("CoreSession." + name + " invoked without a transaction," + " check debug logs for more information"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("CoreSession." + name + " invoked without a transaction"), new Throwable());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Transaction main = this.threadBound.get();
        if (main == null) {
            try {
                main = TransactionHelper.lookupTransactionManager().getTransaction();
                if (main != null && main.getStatus() == 0) {
                    ConnectionHelper.registerSynchronizationLast((Synchronization)this);
                    this.threadBound.set(main);
                }
            }
            catch (NamingException e) {
            }
            catch (Exception e) {
                log.error((Object)"Error on transaction synchronizer registration", (Throwable)e);
            }
            this.checkTxActiveRequired(method);
        }
        try {
            return method.invoke((Object)this.session, args);
        }
        catch (Throwable t) {
            Throwable tt;
            if (t instanceof InvocationTargetException && (tt = ((InvocationTargetException)t).getTargetException()) != null) {
                t = tt;
            }
            if (TransactionHelper.isTransactionActive() && this.needsRollback(method, t)) {
                TransactionHelper.setTransactionRollbackOnly();
                if (!(t instanceof ConcurrentUpdateException)) {
                    log.warn((Object)("Setting transaction ROLLBACK ONLY due to exception (check DEBUG logs for stacktrace): " + t));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting transaction ROLLBACK ONLY due to exception: " + t), t);
                }
            }
            throw t;
        }
    }

    protected boolean needsRollback(Method method, Throwable t) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType() != NoRollbackOnException.class) continue;
            return false;
        }
        return true;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        Transaction current = null;
        try {
            current = TransactionHelper.lookupTransactionManager().getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException("no tx", e);
        }
        Transaction main = this.threadBound.get();
        if (main.equals(current)) {
            this.threadBound.remove();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.session + ')';
    }
}

