/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.cache.SimpleCacheFilter;
import org.nuxeo.ecm.platform.web.common.ajax.service.AjaxProxyService;
import org.nuxeo.ecm.platform.web.common.ajax.service.ProxyURLConfigEntry;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.LRUCachingMap;
import org.nuxeo.runtime.api.Framework;

public class AjaxProxyServlet
extends HttpServlet {
    public static final String X_METHOD_HEADER = "X-Requested-Method";
    protected static AjaxProxyService service;
    protected static Map<String, String> requestsCache;
    protected static final ReentrantReadWriteLock cacheLock;
    private static final long serialVersionUID = 1L;
    private static final Log log;

    protected static AjaxProxyService getService() {
        if (service == null) {
            service = (AjaxProxyService)Framework.getLocalService(AjaxProxyService.class);
        }
        return service;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getMethod(), req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getHeader(X_METHOD_HEADER), req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AjaxProxyServlet.handleProxy(req.getMethod(), req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleProxy(String method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String targetURL;
        String requestType = req.getParameter("type");
        if (requestType == null) {
            requestType = "text";
        }
        if ((targetURL = req.getParameter("url")) == null) {
            return;
        }
        String cache = req.getParameter("cache");
        ProxyURLConfigEntry entry = AjaxProxyServlet.getService().getConfigForURL(targetURL);
        if (entry == null || !entry.isGranted()) {
            resp.sendError(403);
            log.warn((Object)("client requested proxying for unauthorized url " + targetURL));
            return;
        }
        String body = null;
        String cacheKey = targetURL;
        if (entry.useCache()) {
            if (entry.useCache()) {
                cacheKey = cacheKey + AjaxProxyServlet.getSessionId(req);
            }
            try {
                cacheLock.readLock().lock();
                body = requestsCache.get(cacheKey);
            }
            finally {
                cacheLock.readLock().unlock();
            }
        }
        boolean foundInCache = true;
        if (body == null) {
            foundInCache = false;
            body = AjaxProxyServlet.doRequest(method, targetURL, req);
        }
        if (!foundInCache && entry.useCache()) {
            try {
                cacheLock.writeLock().lock();
                requestsCache.put(cacheKey, body);
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
        if (requestType.equals("text")) {
            resp.setContentType("text/plain");
        } else if (requestType.equals("xml")) {
            resp.setContentType("text/xml");
        }
        if (cache != null) {
            SimpleCacheFilter.addCacheHeader(resp, cache);
        }
        resp.getWriter().write(body);
        resp.setStatus(200);
    }

    protected static String getSessionId(HttpServletRequest req) {
        String jSessionId = null;
        for (Cookie cookie : req.getCookies()) {
            if (!"JSESSIONID".equalsIgnoreCase(cookie.getName())) continue;
            jSessionId = cookie.getValue();
            break;
        }
        return jSessionId;
    }

    protected static String doRequest(String method, String targetURL, HttpServletRequest req) throws IOException {
        GetMethod httpMethod;
        HttpClient client = new HttpClient();
        if ("GET".equals(method)) {
            httpMethod = new GetMethod(targetURL);
        } else if ("POST".equals(method)) {
            httpMethod = new PostMethod(targetURL);
            ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)req.getInputStream()));
        } else if ("PUT".equals(method)) {
            httpMethod = new PutMethod(targetURL);
            ((PutMethod)httpMethod).setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)req.getInputStream()));
        } else {
            throw new IllegalStateException("Unknown HTTP method: " + method);
        }
        Map params = req.getParameterMap();
        for (String paramName : params.keySet()) {
            httpMethod.getParams().setParameter(paramName, params.get(paramName));
        }
        client.executeMethod((HttpMethod)httpMethod);
        String body = httpMethod.getResponseBodyAsString();
        httpMethod.releaseConnection();
        return body;
    }

    static {
        requestsCache = new LRUCachingMap<String, String>(250);
        cacheLock = new ReentrantReadWriteLock();
        log = LogFactory.getLog(AjaxProxyServlet.class);
    }
}

