/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.helper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PreviewHelper {
    public static final String PREVIEWURL_PREFIX = "restAPI/preview/";
    public static final String PREVIEWURL_DEFAULTXPATH = "default";
    protected static final Map<String, Boolean> hasPreviewByType = new ConcurrentHashMap<String, Boolean>();

    private PreviewHelper() {
    }

    public static String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, PREVIEWURL_DEFAULTXPATH);
    }

    public static String getPreviewURL(DocumentModel doc, String xpath) {
        if (xpath == null) {
            xpath = PREVIEWURL_DEFAULTXPATH;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PREVIEWURL_PREFIX);
        sb.append(doc.getRepositoryName());
        sb.append("/");
        sb.append(doc.getId());
        sb.append("/");
        sb.append(xpath);
        sb.append("/");
        return sb.toString();
    }

    public static DocumentRef getDocumentRefFromPreviewURL(String url) {
        if (url == null) {
            return null;
        }
        String[] urlParts = url.split(PREVIEWURL_PREFIX);
        String[] parts = urlParts[1].split("/");
        String strRef = parts[1];
        return new IdRef(strRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeSupportsPreview(DocumentModel doc) {
        String docType = doc.getType();
        if (hasPreviewByType.containsKey(docType)) {
            return hasPreviewByType.get(docType);
        }
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)doc.getAdapter(HtmlPreviewAdapter.class);
        if (adapter == null) {
            Map<String, Boolean> map = hasPreviewByType;
            synchronized (map) {
                hasPreviewByType.put(docType, false);
                return false;
            }
        }
        Map<String, Boolean> map = hasPreviewByType;
        synchronized (map) {
            hasPreviewByType.put(docType, true);
            return true;
        }
    }

    public static boolean docHasBlobToPreview(DocumentModel document) throws PreviewException {
        HtmlPreviewAdapter adapter = (HtmlPreviewAdapter)document.getAdapter(HtmlPreviewAdapter.class);
        return adapter == null ? false : adapter.hasBlobToPreview();
    }
}

