/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.security.permission.Identifier;
import org.jboss.seam.security.permission.ClassIdentifierStrategy;
import org.jboss.seam.security.permission.EntityIdentifierStrategy;
import org.jboss.seam.security.permission.IdentifierStrategy;

@Name(value="org.jboss.seam.security.identifierPolicy")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=0)
public class IdentifierPolicy
implements Serializable {
    private static final long serialVersionUID = 684295244567560969L;
    private Map<Class<?>, IdentifierStrategy> strategies = new ConcurrentHashMap();
    private Set<IdentifierStrategy> registeredStrategies = new HashSet<IdentifierStrategy>();

    @Create
    public void create() {
        if (this.registeredStrategies.isEmpty()) {
            this.registeredStrategies.add(new EntityIdentifierStrategy());
            this.registeredStrategies.add(new ClassIdentifierStrategy());
        }
    }

    public String getIdentifier(Object target) {
        if (target instanceof String) {
            return (String)target;
        }
        IdentifierStrategy strategy = this.strategies.get(target.getClass());
        if (strategy == null) {
            Class<? extends IdentifierStrategy> strategyClass;
            if (target.getClass().isAnnotationPresent(Identifier.class) && (strategyClass = target.getClass().getAnnotation(Identifier.class).value()) != IdentifierStrategy.class) {
                try {
                    strategy = strategyClass.newInstance();
                    this.strategies.put(target.getClass(), strategy);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating IdentifierStrategy for object " + target, ex);
                }
            }
            for (IdentifierStrategy s : this.registeredStrategies) {
                if (!s.canIdentify(target.getClass())) continue;
                strategy = s;
                this.strategies.put(target.getClass(), strategy);
                break;
            }
        }
        return strategy != null ? strategy.getIdentifier(target) : null;
    }

    public Set<IdentifierStrategy> getRegisteredStrategies() {
        return this.registeredStrategies;
    }

    public void setRegisteredStrategies(Set<IdentifierStrategy> registeredStrategies) {
        this.registeredStrategies = registeredStrategies;
    }
}

