/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.Persistence;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Startup
public class EntityManagerFactory {
    private javax.persistence.EntityManagerFactory entityManagerFactory;
    private String persistenceUnitName;
    private Map<String, String> persistenceUnitProperties;

    @Unwrap
    public javax.persistence.EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Create
    public void startup(Component component) throws Exception {
        if (this.persistenceUnitName == null) {
            this.persistenceUnitName = component.getName();
        }
        this.entityManagerFactory = this.createEntityManagerFactory();
    }

    @Destroy
    public void shutdown() {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }

    protected javax.persistence.EntityManagerFactory createEntityManagerFactory() {
        HashMap properties = new HashMap();
        Hashtable jndiProperties = Naming.getInitialContextProperties();
        if (jndiProperties != null) {
            for (Map.Entry entry : jndiProperties.entrySet()) {
                properties.put("hibernate.jndi." + (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.persistenceUnitProperties != null) {
            properties.putAll(this.persistenceUnitProperties);
        }
        if (properties.isEmpty()) {
            return Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
        return Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Map<String, String> getPersistenceUnitProperties() {
        return this.persistenceUnitProperties;
    }

    public void setPersistenceUnitProperties(Map<String, String> persistenceUnitProperties) {
        this.persistenceUnitProperties = persistenceUnitProperties;
    }
}

