/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cache;

import org.jboss.cache.CacheException;
import org.jboss.cache.Node;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.aop.PojoCache;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.cache.AbstractJBossCacheProvider;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Name(value="org.jboss.seam.cache.cacheProvider")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(value=false, precedence=0, classDependencies={"org.jboss.cache.aop.PojoCache", "org.jgroups.MembershipListener", "org.jboss.aop.Dispatcher"})
@AutoCreate
public class JbossPojoCacheProvider
extends AbstractJBossCacheProvider<PojoCache> {
    private PojoCache cache;
    private static final LogProvider log = Logging.getLogProvider(JbossPojoCacheProvider.class);

    @Create
    public void create() {
        log.debug("Starting JBoss POJO Cache 1.x");
        try {
            this.cache = new PojoCache();
            new PropertyConfigurator().configure((Object)this.cache, this.getConfigurationAsStream());
            this.cache.createService();
            this.cache.startService();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting JBoss POJO Cache 1.x", e);
        }
    }

    @Destroy
    public void destroy() {
        log.debug("Stopping JBoss Treecache 1.x");
        try {
            this.cache.stopService();
            this.cache.destroyService();
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error stopping JBoss Treecache 1.x", e);
        }
        this.cache = null;
    }

    @Override
    public Object get(String region, String key) {
        try {
            Node node = this.cache.get(this.getFqn(region));
            if (node != null) {
                return node.get((Object)key);
            }
            return null;
        }
        catch (CacheException e) {
            throw new IllegalStateException(String.format("Cache throw exception when trying to get %s from region %s.", key, region), e);
        }
    }

    @Override
    public void put(String region, String key, Object object) {
        try {
            this.cache.put(this.getFqn(region), (Object)key, object);
        }
        catch (CacheException e) {
            throw new IllegalStateException(String.format("JBoss Cache throw exception when adding object for key %s to region %s", key, region), e);
        }
    }

    @Override
    public void remove(String region, String key) {
        try {
            this.cache.remove(this.getFqn(region), (Object)key);
        }
        catch (CacheException e) {
            throw new IllegalStateException(String.format("JBoss Cache throw exception when removing object for key %s in region %s", key, region), e);
        }
    }

    @Override
    public PojoCache getDelegate() {
        return this.cache;
    }

    @Override
    public void clear() {
        try {
            this.cache.remove(this.getFqn(null));
        }
        catch (CacheException e) {
            throw new IllegalStateException(String.format("JBoss Cache throw exception when clearing default cache.", new Object[0]), e);
        }
    }
}

