/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;
import org.nuxeo.ecm.platform.userworkspace.core.service.UserWorkspaceServiceImplComponent;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUserWorkspaceImpl
implements UserWorkspaceService {
    private static final Log log = LogFactory.getLog(DefaultUserWorkspaceServiceImpl.class);
    private static final long serialVersionUID = 1L;
    protected String targetDomainName;

    protected String getDomainName(CoreSession userCoreSession, DocumentModel currentDocument) {
        if (this.targetDomainName == null) {
            RootDomainFinder finder = new RootDomainFinder(userCoreSession);
            try {
                finder.runUnrestricted();
            }
            catch (ClientException e) {
                log.error((Object)"Unable to find root domain for UserWorkspace", (Throwable)e);
                return null;
            }
            this.targetDomainName = finder.domaineName;
        }
        return this.targetDomainName;
    }

    protected String getUserWorkspaceNameForUser(String userName) {
        return IdUtils.generateId((String)userName, (String)"-", (boolean)false, (int)30);
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String usedUsername, DocumentModel currentDocument) throws ClientException {
        String domainName = this.getDomainName(userCoreSession, currentDocument);
        if (domainName == null) {
            throw new ClientException("Unable to find root domain for UserWorkspace");
        }
        Path path = new Path("/" + domainName);
        path = path.append("UserWorkspaces");
        return path.toString();
    }

    protected String computePathForUserWorkspace(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        String rootPath = this.computePathUserWorkspaceRoot(userCoreSession, userName, currentDocument);
        Path path = new Path(rootPath);
        path = path.append(this.getUserWorkspaceNameForUser(userName));
        return path.toString();
    }

    public DocumentModel getCurrentUserPersonalWorkspace(String userName, DocumentModel currentDocument) throws ClientException {
        if (currentDocument == null) {
            return null;
        }
        return this.getCurrentUserPersonalWorkspace(null, userName, currentDocument.getCoreSession(), currentDocument);
    }

    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession, DocumentModel context) throws ClientException {
        return this.getCurrentUserPersonalWorkspace(userCoreSession.getPrincipal(), null, userCoreSession, context);
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(Principal principal, String userName, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        if (principal == null && StringUtils.isEmpty((String)userName)) {
            throw new ClientException("You should pass at least one principal or one username");
        }
        String usedUsername = principal instanceof NuxeoPrincipal ? ((NuxeoPrincipal)principal).getActingUser() : userName;
        PathRef uwsDocRef = new PathRef(this.computePathForUserWorkspace(userCoreSession, usedUsername, context));
        if (!userCoreSession.exists((DocumentRef)uwsDocRef)) {
            PathRef rootRef = new PathRef(this.computePathUserWorkspaceRoot(userCoreSession, usedUsername, context));
            uwsDocRef = this.createUserWorkspace(rootRef, uwsDocRef, userCoreSession, principal, usedUsername);
        }
        if (userCoreSession.getClass().getSimpleName().equals("LocalSession")) {
            userCoreSession.save();
        }
        return userCoreSession.getDocument((DocumentRef)uwsDocRef);
    }

    protected synchronized PathRef createUserWorkspace(PathRef rootRef, PathRef userWSRef, CoreSession userCoreSession, Principal principal, String userName) throws ClientException {
        UnrestrictedUWSCreator creator = new UnrestrictedUWSCreator(rootRef, userWSRef, userCoreSession, principal, userName);
        creator.runUnrestricted();
        userWSRef = creator.userWSRef;
        return userWSRef;
    }

    public DocumentModel getUserPersonalWorkspace(NuxeoPrincipal principal, DocumentModel context) throws ClientException {
        return this.getCurrentUserPersonalWorkspace((Principal)principal, null, context.getCoreSession(), context);
    }

    public DocumentModel getUserPersonalWorkspace(String userName, DocumentModel context) throws ClientException {
        try {
            UnrestrictedUserWorkspaceFinder finder = new UnrestrictedUserWorkspaceFinder(userName, context);
            finder.runUnrestricted();
            return finder.getDetachedUserWorkspace();
        }
        catch (Exception e) {
            log.warn((Object)"Error while trying to get user workspace unrestricted");
            throw new ClientException((Throwable)e);
        }
    }

    protected String buildUserWorkspaceTitle(Principal principal, String userName) {
        if (userName == null) {
            return null;
        }
        UserManager userManager = null;
        try {
            userManager = (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            log.debug((Object)"failed to get user service", (Throwable)e);
        }
        if (userManager == null) {
            return userName;
        }
        DocumentModel userModel = null;
        try {
            userModel = userManager.getUserModel(userName);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to fetch user model", (Throwable)e);
        }
        if (userModel == null) {
            return userName;
        }
        UserAdapter userAdapter = null;
        userAdapter = (UserAdapter)userModel.getAdapter(UserAdapter.class);
        if (userAdapter == null) {
            return userName;
        }
        StringBuilder title = new StringBuilder();
        try {
            String lastName;
            String firstName = userAdapter.getFirstName();
            if (firstName != null && firstName.trim().length() > 0) {
                title.append(firstName);
            }
            if ((lastName = userAdapter.getLastName()) != null && lastName.trim().length() > 0) {
                if (title.length() > 0) {
                    title.append(" ");
                }
                title.append(lastName);
            }
        }
        catch (ClientException ce) {
            log.error((Object)("Failed to compute the title for " + userName + "'s workspace"), (Throwable)ce);
        }
        if (title.length() > 0) {
            return title.toString();
        }
        return userName;
    }

    protected void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, String eventId, Map<String, Serializable> properties) throws ClientException {
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        EventContextImpl eventContext = null;
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        ((EventProducer)Framework.getLocalService(EventProducer.class)).fireEvent(event);
    }

    protected UserWorkspaceServiceImplComponent getComponent() {
        return (UserWorkspaceServiceImplComponent)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.userworkspace.UserWorkspaceService"));
    }

    protected abstract DocumentModel doCreateUserWorkspacesRoot(CoreSession var1, PathRef var2) throws ClientException;

    protected abstract DocumentModel doCreateUserWorkspace(CoreSession var1, PathRef var2, Principal var3, String var4) throws ClientException;

    protected class RootDomainFinder
    extends UnrestrictedSessionRunner {
        protected String domaineName;

        public RootDomainFinder(CoreSession userCoreSession) {
            super(userCoreSession);
        }

        public void run() throws ClientException {
            String targetName = AbstractUserWorkspaceImpl.this.getComponent().getTargetDomainName();
            PathRef ref = new PathRef("/" + targetName);
            if (this.session.exists((DocumentRef)ref)) {
                this.domaineName = targetName;
                return;
            }
            DocumentModelList domains = this.session.query("select * from Domain order by dc:created");
            if (!domains.isEmpty()) {
                this.domaineName = ((DocumentModel)domains.get(0)).getName();
            }
        }
    }

    protected class UnrestrictedUserWorkspaceFinder
    extends UnrestrictedSessionRunner {
        protected DocumentModel userWorkspace;
        protected String userName;
        protected DocumentModel context;

        protected UnrestrictedUserWorkspaceFinder(String userName, DocumentModel context) throws Exception {
            super(context.getCoreSession().getRepositoryName(), userName);
            this.userName = userName;
            this.context = context;
        }

        public void run() throws ClientException {
            this.userWorkspace = AbstractUserWorkspaceImpl.this.getCurrentUserPersonalWorkspace(null, this.userName, this.session, this.context);
            if (this.userWorkspace != null) {
                this.userWorkspace.detach(true);
            }
        }

        public DocumentModel getDetachedUserWorkspace() throws ClientException {
            return this.userWorkspace;
        }
    }

    protected class UnrestrictedUWSCreator
    extends UnrestrictedSessionRunner {
        PathRef rootRef;
        PathRef userWSRef;
        String userName;
        Principal principal;

        public UnrestrictedUWSCreator(PathRef rootRef, PathRef userWSRef, CoreSession userCoreSession, Principal principal, String userName) {
            super(userCoreSession);
            this.rootRef = rootRef;
            this.userWSRef = userWSRef;
            this.userName = userName;
            this.principal = principal;
        }

        public void run() throws ClientException {
            if (!this.session.exists((DocumentRef)this.rootRef)) {
                DocumentModel root;
                try {
                    root = AbstractUserWorkspaceImpl.this.doCreateUserWorkspacesRoot(this.session, this.rootRef);
                }
                catch (Exception e) {
                    AbstractUserWorkspaceImpl.this.targetDomainName = null;
                    this.rootRef = new PathRef(AbstractUserWorkspaceImpl.this.computePathUserWorkspaceRoot(this.session, this.userName, null));
                    root = AbstractUserWorkspaceImpl.this.doCreateUserWorkspacesRoot(this.session, this.rootRef);
                    this.userWSRef = new PathRef(AbstractUserWorkspaceImpl.this.computePathForUserWorkspace(this.session, this.userName, null));
                }
                assert (root.getPathAsString().equals(this.rootRef.toString()));
            }
            if (!this.session.exists((DocumentRef)this.userWSRef)) {
                DocumentModel uw = AbstractUserWorkspaceImpl.this.doCreateUserWorkspace(this.session, this.userWSRef, this.principal, this.userName);
                assert (uw.getPathAsString().equals(this.userWSRef.toString()));
            }
            this.session.save();
        }
    }
}

