/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.event.Event;
import org.openjena.atlas.event.EventListener;
import org.openjena.atlas.event.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private static EventManager eventManager = new EventManager();
    private Map<Object, Map<EventType, List<EventListener>>> listenersByObject = new HashMap<Object, Map<EventType, List<EventListener>>>();
    private Map<EventType, List<EventListener>> listenersAllObjects = new HashMap<EventType, List<EventListener>>();

    public static void register(Object object, EventType type, EventListener listener) {
        eventManager.register$(object, type, listener);
    }

    public static void unregister(Object object, EventType type, EventListener listener) {
        eventManager.unregister$(object, type, listener);
    }

    public static void send(Object dest, Event event) {
        eventManager.send$(dest, event);
    }

    private EventManager() {
    }

    private void register$(Object object, EventType type, EventListener listener) {
        List<EventListener> z;
        Map<EventType, List<EventListener>> x = this.get(object);
        if (x == null) {
            x = new HashMap<EventType, List<EventListener>>();
            this.listenersByObject.put(object, x);
        }
        if ((z = x.get(type)) == null) {
            z = new ArrayList<EventListener>();
            x.put(type, z);
        }
        z.add(listener);
    }

    private void unregister$(Object object, EventType type, EventListener listener) {
        List<EventListener> x = this.find(object, type);
        if (x == null) {
            return;
        }
        x.remove(listener);
        if (x.size() != 0) {
            return;
        }
        if (object == null) {
            this.listenersAllObjects.remove(type);
            return;
        }
        this.listenersByObject.get(object).remove(type);
        if (this.listenersByObject.get(object).size() == 0) {
            this.listenersByObject.remove(object);
        }
    }

    private void send$(Object dest, Event event) {
        Map<EventType, List<EventListener>> map;
        if (dest != null && (map = this.listenersByObject.get(dest)) != null) {
            this.send(dest, event, map);
        }
        this.send(dest, event, this.listenersAllObjects);
    }

    private void send(Object dest, Event event, Map<EventType, List<EventListener>> listeners) {
        List<EventListener> x = listeners.get(event.getType());
        if (x != null) {
            for (EventListener listener : x) {
                listener.event(dest, event);
            }
        }
    }

    private void deliveryFailure(Object object, Event event) {
    }

    private Map<EventType, List<EventListener>> get(Object object) {
        if (object == null) {
            return this.listenersAllObjects;
        }
        return this.listenersByObject.get(object);
    }

    private List<EventListener> find(Object object, EventType type) {
        Map<EventType, List<EventListener>> x = this.get(object);
        if (x == null) {
            return null;
        }
        List<EventListener> z = x.get(type);
        return z;
    }
}

