/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import java.util.Collection;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedConnection;

public class RedisEmbeddedLuaLibrary
extends TwoArgFunction {
    protected final RedisEmbeddedConnection connection;

    public RedisEmbeddedLuaLibrary(RedisEmbeddedConnection connection) {
        this.connection = connection;
    }

    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable library = RedisEmbeddedLuaLibrary.tableOf();
        library.set("call", (LuaValue)new RedisCall());
        env.set("redis", (LuaValue)library);
        return library;
    }

    protected LuaValue valueOfOrFalse(Object value) {
        if (value == null) {
            return LuaValue.valueOf((boolean)false);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return CoerceJavaToLua.coerce((Object)collection.toArray());
        }
        return CoerceJavaToLua.coerce((Object)value);
    }

    class RedisCall
    extends LibFunction {
        RedisCall() {
        }

        public Varargs invoke(Varargs varargs) {
            String opcode = varargs.checkjstring(1);
            switch (opcode.toLowerCase()) {
                case "del": {
                    return this.call(varargs.arg(1), (LuaValue)LuaValue.tableOf((Varargs)varargs, (int)1));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }

        public LuaValue call(LuaValue luaOpcode, LuaValue luaKey) {
            String opcode = (String)CoerceLuaToJava.coerce((LuaValue)luaOpcode, String.class);
            String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
            switch (opcode.toLowerCase()) {
                case "get": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.get(key));
                }
                case "del": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.del((String[])CoerceLuaToJava.coerce((LuaValue)luaKey, String[].class)));
                }
                case "keys": {
                    LuaTable table = LuaValue.tableOf();
                    int i = 0;
                    for (String value : RedisEmbeddedLuaLibrary.this.connection.keys(key)) {
                        table.rawset(++i, (LuaValue)LuaValue.valueOf((String)value));
                    }
                    return table;
                }
            }
            throw new UnsupportedOperationException(opcode);
        }

        public LuaValue call(LuaValue luaOpcode, LuaValue luaKey, LuaValue luaArg) {
            String opcode = (String)CoerceLuaToJava.coerce((LuaValue)luaOpcode, String.class);
            String key = (String)CoerceLuaToJava.coerce((LuaValue)luaKey, String.class);
            String arg = (String)CoerceLuaToJava.coerce((LuaValue)luaArg, String.class);
            switch (opcode.toLowerCase()) {
                case "set": {
                    return RedisEmbeddedLuaLibrary.this.valueOfOrFalse(RedisEmbeddedLuaLibrary.this.connection.set(key, arg));
                }
            }
            throw new UnsupportedOperationException(opcode);
        }
    }
}

