/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import java.util.Random;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class RedisEmbeddedGuessConnectionError {
    protected final Thread ownerThread = Thread.currentThread();

    protected void guessError() {
        if (!this.onThread()) {
            return;
        }
        this.doGuessError();
    }

    protected abstract void doGuessError();

    protected boolean onThread() {
        return Thread.currentThread().equals(this.ownerThread);
    }

    public static class OnRandomCall
    extends RedisEmbeddedGuessConnectionError {
        protected final Random random = new Random();

        @Override
        protected void doGuessError() throws JedisConnectionException {
            if (this.random.nextBoolean()) {
                throw new JedisConnectionException("random call error");
            }
        }
    }

    public static class OnEveryCall
    extends RedisEmbeddedGuessConnectionError {
        @Override
        protected void doGuessError() throws JedisConnectionException {
            throw new JedisConnectionException("every call error");
        }
    }

    public static class OnFirstCall
    extends RedisEmbeddedGuessConnectionError {
        protected boolean fired;

        @Override
        protected void doGuessError() throws JedisConnectionException {
            if (!this.fired) {
                this.fired = true;
                throw new JedisConnectionException("first call error");
            }
        }
    }

    public static class NoError
    extends RedisEmbeddedGuessConnectionError {
        @Override
        protected void doGuessError() throws JedisConnectionException {
        }
    }
}

