/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.embedded;

import com.lordofthejars.nosqlunit.redis.embedded.NoArgsJedis;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.joor.Reflect;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedConnection;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedGuessConnectionError;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedLuaEngine;
import redis.clients.jedis.Jedis;

public class RedisEmbeddedFactory
implements PooledObjectFactory<Jedis> {
    protected final RedisEmbeddedConnection connection = new RedisEmbeddedConnection(this);
    protected RedisEmbeddedGuessConnectionError error = new RedisEmbeddedGuessConnectionError.NoError();
    protected final RedisEmbeddedLuaEngine lua = new RedisEmbeddedLuaEngine(this.connection);

    public Jedis createProxy() {
        return (Jedis)Jedis.class.cast(Enhancer.create(NoArgsJedis.class, (Callback)new TryFailoverMethod()));
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        Jedis jedis = this.createProxy();
        DefaultPooledObject pooled = new DefaultPooledObject((Object)jedis);
        LogFactory.getLog(RedisEmbeddedFactory.class).trace((Object)("created " + pooled));
        return pooled;
    }

    public void destroyObject(PooledObject<Jedis> p) throws Exception {
    }

    public boolean validateObject(PooledObject<Jedis> p) {
        return true;
    }

    public void activateObject(PooledObject<Jedis> p) throws Exception {
    }

    public void passivateObject(PooledObject<Jedis> p) throws Exception {
    }

    public class TryFailoverMethod
    implements MethodInterceptor {
        public Object intercept(Object object, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
            if (!method.getDeclaringClass().equals(Object.class)) {
                RedisEmbeddedFactory.this.error.guessError();
            }
            return Reflect.on((Object)((Object)RedisEmbeddedFactory.this.connection)).call(method.getName(), arguments).get();
        }
    }
}

