/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.core.cache.CacheFeature;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisComponent;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.RedisFailoverExecutor;
import org.nuxeo.ecm.core.redis.RedisHostDescriptor;
import org.nuxeo.ecm.core.redis.RedisPoolExecutor;
import org.nuxeo.ecm.core.redis.RedisSentinelDescriptor;
import org.nuxeo.ecm.core.redis.RedisServerDescriptor;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedGuessConnectionError;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedPool;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedSynchronizedExecutor;
import org.nuxeo.ecm.core.redis.embedded.RedisEmbeddedTraceExecutor;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.StreamRef;
import org.nuxeo.runtime.test.InlineRef;
import org.nuxeo.runtime.test.protocols.inline.InlineURLFactory;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.SimpleFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import redis.clients.util.Pool;

@Features(value={CoreFeature.class, CacheFeature.class})
@RepositoryConfig(init=DefaultRepositoryInit.class)
public class RedisFeature
extends SimpleFeature {
    protected Config config;

    public RedisFeature() {
    }

    public RedisFeature(Config config) {
        this.config = config;
    }

    protected RedisServerDescriptor newRedisServerDescriptor() {
        RedisServerDescriptor desc = new RedisServerDescriptor();
        desc.hosts = new RedisHostDescriptor[]{new RedisHostDescriptor(this.config.host(), this.config.port())};
        return desc;
    }

    protected RedisSentinelDescriptor newRedisSentinelDescriptor() {
        RedisSentinelDescriptor desc = new RedisSentinelDescriptor();
        desc.master = "mymaster";
        desc.hosts = new RedisHostDescriptor[]{new RedisHostDescriptor(this.config.host(), this.config.port())};
        return desc;
    }

    public static void clear() throws IOException {
        RedisAdmin admin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        admin.clear("*");
    }

    public static boolean setup(RuntimeHarness harness) throws Exception {
        return new RedisFeature((Config)Defaults.of(Config.class)).setupMe(harness);
    }

    protected boolean setupMe(RuntimeHarness harness) throws Exception {
        if (Mode.disabled.equals((Object)this.config.mode())) {
            return false;
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.event") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.event");
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.storage") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.storage");
        }
        if (harness.getOSGiAdapter().getBundle("org.nuxeo.ecm.core.cache") == null) {
            harness.deployBundle("org.nuxeo.ecm.core.cache");
        }
        harness.deployBundle("org.nuxeo.ecm.core.redis");
        harness.deployTestContrib("org.nuxeo.ecm.core.redis", RedisFeature.class.getResource("/redis-contribs.xml"));
        if (Mode.embedded.equals((Object)this.config.mode())) {
            RedisComponent component = (RedisComponent)Framework.getRuntime().getComponent(RedisComponent.class.getPackage().getName());
            Object executor = new RedisPoolExecutor((Pool)new RedisEmbeddedPool());
            executor = new RedisEmbeddedTraceExecutor((RedisExecutor)executor);
            executor = new RedisEmbeddedSynchronizedExecutor((RedisExecutor)executor);
            executor = new RedisFailoverExecutor(10, (RedisExecutor)executor);
            component.handleNewExecutor((RedisExecutor)executor);
        } else {
            RuntimeContext context = Framework.getRuntime().getContext();
            context.deploy((StreamRef)this.toDescriptor(this.config));
        }
        RedisFeature.clear();
        return true;
    }

    private InlineRef toDescriptor(Config config) throws IOException, URISyntaxException, ParserConfigurationException {
        File sourceFile = new File(RedisFeature.class.getResource("/redis-config.xml").toURI());
        TextTemplate template = new TextTemplate();
        template.setVariable("timeout", Long.toString(config.failoverTimeout()));
        RedisSentinelDescriptor desc = null;
        XMap xmap = new XMap();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element extension = (Element)doc.appendChild(doc.createElement("extension"));
        extension.setAttribute("target", "org.nuxeo.ecm.core.redis.RedisConnector");
        extension.setAttribute("point", "configuration");
        switch (config.mode()) {
            case sentinel: {
                xmap.register(RedisSentinelDescriptor.class);
                desc = this.newRedisSentinelDescriptor();
                break;
            }
            case server: {
                extension.setAttribute("target", "org.nuxeo.ecm.core.redis.RedisSentinel");
                xmap.register(RedisServerDescriptor.class);
                desc = this.newRedisServerDescriptor();
                break;
            }
        }
        String ext = "";
        if (desc != null) {
            xmap.toXML((Object)desc, doc.getDocumentElement());
            ext = DOMSerializer.toStringOmitXml((Element)((Element)doc.getDocumentElement().getChildNodes().item(0)));
        }
        template.setVariable("extension", ext);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        template.process((InputStream)new FileInputStream(sourceFile), (OutputStream)bos);
        return new InlineRef("redis-test", bos.toString());
    }

    public void initialize(FeaturesRunner runner) throws Exception {
        this.config = (Config)runner.getConfig(Config.class);
        ((CacheFeature)runner.getFeature(CacheFeature.class)).enable();
        InlineURLFactory.install();
    }

    public void start(FeaturesRunner runner) throws Exception {
        this.setupMe(((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness());
    }

    public static enum Mode {
        disabled,
        embedded,
        server,
        sentinel;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Config {
        public Mode mode() default Mode.embedded;

        public String host() default "localhost";

        public int port() default 0;

        public String prefix() default "nuxeo:test:";

        public long failoverTimeout() default -1L;

        public Class<? extends RedisEmbeddedGuessConnectionError> guessError() default RedisEmbeddedGuessConnectionError.NoError.class;
    }
}

