/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.specs.IVecInt;

public final class Heap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVecInt heap = new VecInt();
    private final IVecInt indices = new VecInt();
    private final double[] activity;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.core.Heap");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private static final int left(int i) {
        return i << 1;
    }

    private static final int right(int i) {
        return i << 1 ^ 1;
    }

    private static final int parent(int i) {
        return i >> 1;
    }

    private final boolean comp(int a, int b) {
        return this.activity[a] > this.activity[b];
    }

    final void percolateUp(int i) {
        int x = this.heap.get(i);
        while (Heap.parent(i) != 0 && this.comp(x, this.heap.get(Heap.parent(i)))) {
            this.heap.set(i, this.heap.get(Heap.parent(i)));
            this.indices.set(this.heap.get(i), i);
            i = Heap.parent(i);
        }
        this.heap.set(i, x);
        this.indices.set(x, i);
    }

    final void percolateDown(int i) {
        int x = this.heap.get(i);
        while (Heap.left(i) < this.heap.size()) {
            int child;
            int n = child = Heap.right(i) < this.heap.size() && this.comp(this.heap.get(Heap.right(i)), this.heap.get(Heap.left(i))) ? Heap.right(i) : Heap.left(i);
            if (!this.comp(this.heap.get(child), x)) break;
            this.heap.set(i, this.heap.get(child));
            this.indices.set(this.heap.get(i), i);
            i = child;
        }
        this.heap.set(i, x);
        this.indices.set(x, i);
    }

    boolean ok(int n) {
        return n >= 0 && n < this.indices.size();
    }

    public Heap(double[] activity) {
        this.activity = activity;
        this.heap.push(-1);
    }

    public void setBounds(int size) {
        if (!$assertionsDisabled && size < 0) {
            throw new AssertionError();
        }
        this.indices.growTo(size, 0);
    }

    public boolean inHeap(int n) {
        if (!$assertionsDisabled && !this.ok(n)) {
            throw new AssertionError();
        }
        return this.indices.get(n) != 0;
    }

    public void increase(int n) {
        if (!$assertionsDisabled && !this.ok(n)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.inHeap(n)) {
            throw new AssertionError();
        }
        this.percolateUp(this.indices.get(n));
    }

    public boolean empty() {
        return this.heap.size() == 1;
    }

    public int size() {
        return this.heap.size() - 1;
    }

    public int get(int i) {
        int r = this.heap.get(i);
        this.heap.set(i, this.heap.last());
        this.indices.set(this.heap.get(i), i);
        this.indices.set(r, 0);
        this.heap.pop();
        if (this.heap.size() > 1) {
            this.percolateDown(1);
        }
        return r;
    }

    public void insert(int n) {
        if (!$assertionsDisabled && !this.ok(n)) {
            throw new AssertionError();
        }
        this.indices.set(n, this.heap.size());
        this.heap.push(n);
        this.percolateUp(this.indices.get(n));
    }

    public int getmin() {
        return this.get(1);
    }

    public boolean heapProperty() {
        return this.heapProperty(1);
    }

    public boolean heapProperty(int i) {
        return i >= this.heap.size() || (Heap.parent(i) == 0 || !this.comp(this.heap.get(i), this.heap.get(Heap.parent(i)))) && this.heapProperty(Heap.left(i)) && this.heapProperty(Heap.right(i));
    }
}

