/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseSQLServer
extends DatabaseHelper {
    public static DatabaseHelper INSTANCE = new DatabaseSQLServer();
    private boolean supportsXA;
    private boolean supportsSequences;
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_PORT = "1433";
    private static final String DEF_DATABASE = "nuxeojunittests";
    private static final String DEF_USER = "nuxeo";
    private static final String DEF_PASSWORD = "nuxeo";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-mssql-contrib.xml";
    private static final boolean MSFT = false;
    private static final String DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    private static final String XA_DATASOURCE = "net.sourceforge.jtds.jdbcx.JtdsDataSource";

    private void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.server", DEF_SERVER);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.port", DEF_PORT);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.database", DEF_DATABASE);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.user", "nuxeo");
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.password", "nuxeo");
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.xadatasource", XA_DATASOURCE);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.driver", DRIVER);
        String url = DRIVER.startsWith("com.microsoft") ? String.format("jdbc:sqlserver://%s:%s;databaseName=%s;user=%s;password=%s", Framework.getProperty((String)"nuxeo.test.vcs.server"), Framework.getProperty((String)"nuxeo.test.vcs.port"), Framework.getProperty((String)"nuxeo.test.vcs.database"), Framework.getProperty((String)"nuxeo.test.vcs.user"), Framework.getProperty((String)"nuxeo.test.vcs.password")) : String.format("jdbc:jtds:sqlserver://%s:%s;databaseName=%s;user=%s;password=%s", Framework.getProperty((String)"nuxeo.test.vcs.server"), Framework.getProperty((String)"nuxeo.test.vcs.port"), Framework.getProperty((String)"nuxeo.test.vcs.database"), Framework.getProperty((String)"nuxeo.test.vcs.user"), Framework.getProperty((String)"nuxeo.test.vcs.password"));
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.url", url);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.idtype", "varchar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Class.forName(DRIVER);
        this.setProperties();
        try (Connection connection = DriverManager.getConnection(Framework.getProperty((String)"nuxeo.test.vcs.url"));){
            DatabaseSQLServer.doOnAllTables(connection, null, null, "DROP TABLE [%s]");
            this.checkSupports(connection);
            if (this.supportsSequences) {
                Statement st = connection.createStatement();
                DatabaseSQLServer.executeSql(st, "IF EXISTS (SELECT 1 FROM sys.sequences WHERE name = 'hierarchy_seq') DROP SEQUENCE hierarchy_seq");
                st.close();
            }
        }
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = XA_DATASOURCE;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ServerName", Framework.getProperty((String)"nuxeo.test.vcs.server"));
        properties.put("PortNumber", Framework.getProperty((String)"nuxeo.test.vcs.port"));
        properties.put("DatabaseName", Framework.getProperty((String)"nuxeo.test.vcs.database"));
        properties.put("User", Framework.getProperty((String)"nuxeo.test.vcs.user"));
        properties.put("Password", Framework.getProperty((String)"nuxeo.test.vcs.password"));
        properties.put("UseCursors", "true");
        descriptor.properties = properties;
        descriptor.fulltextAnalyzer = "French";
        descriptor.fulltextCatalog = "nuxeo";
        descriptor.idType = Framework.getProperty((String)"nuxeo.test.vcs.idtype");
        return descriptor;
    }

    @Override
    public void sleepForFulltext() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSupports(Connection connection) throws SQLException {
        try (Statement st = connection.createStatement();){
            ResultSet rs = st.executeQuery("SELECT SERVERPROPERTY('ProductVersion'), CONVERT(NVARCHAR(100), SERVERPROPERTY('EngineEdition'))");
            rs.next();
            String productVersion = rs.getString(1);
            int majorVersion = Integer.parseInt(productVersion.split("\\.")[0]);
            int engineEdition = rs.getInt(2);
            boolean azure = engineEdition == 5;
            this.supportsXA = !azure;
            this.supportsSequences = majorVersion >= 11 && !azure;
        }
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }

    @Override
    public boolean supportsXA() {
        return this.supportsXA;
    }

    @Override
    public boolean supportsSoftDelete() {
        return true;
    }

    @Override
    public boolean supportsSequenceId() {
        return this.supportsSequences;
    }
}

