/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabasePostgreSQL
extends DatabaseHelper {
    public static DatabaseHelper INSTANCE = new DatabasePostgreSQL();
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_PORT = "5432";
    private static final String DEF_USER = "nuxeo";
    private static final String DEF_PASSWORD = "nuxeo";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-postgresql-contrib.xml";
    private static final String DRIVER = "org.postgresql.Driver";

    protected void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        String db = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.database", this.databaseName);
        String server = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.server", DEF_SERVER);
        String port = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.port", DEF_PORT);
        String user = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.user", "nuxeo");
        String password = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.password", "nuxeo");
        String driver = DatabasePostgreSQL.setProperty("nuxeo.test.vcs.driver", DRIVER);
        String url = String.format("jdbc:postgresql://%s:%s/%s", server, port, db);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.url", url);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.idtype", "varchar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Class.forName(DRIVER);
        this.setProperties();
        try (Connection connection = DriverManager.getConnection(Framework.getProperty((String)"nuxeo.test.vcs.url"), Framework.getProperty((String)"nuxeo.test.vcs.user"), Framework.getProperty((String)"nuxeo.test.vcs.password"));){
            DatabasePostgreSQL.doOnAllTables(connection, null, "public", "DROP TABLE \"%s\" CASCADE");
            Statement st = connection.createStatement();
            DatabasePostgreSQL.executeSql(st, "DROP SEQUENCE IF EXISTS hierarchy_seq");
            st.close();
        }
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "org.postgresql.xa.PGXADataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ServerName", Framework.getProperty((String)"nuxeo.test.vcs.server"));
        properties.put("PortNumber", Framework.getProperty((String)"nuxeo.test.vcs.port"));
        properties.put("DatabaseName", Framework.getProperty((String)"nuxeo.test.vcs.database"));
        properties.put("User", Framework.getProperty((String)"nuxeo.test.vcs.user"));
        properties.put("Password", Framework.getProperty((String)"nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        descriptor.fulltextAnalyzer = "french";
        descriptor.setPathOptimizationsEnabled(true);
        descriptor.setAclOptimizationsEnabled(true);
        descriptor.idType = Framework.getProperty((String)"nuxeo.test.vcs.idtype");
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }

    @Override
    public boolean supportsSoftDelete() {
        return true;
    }

    @Override
    public boolean supportsSequenceId() {
        return true;
    }

    @Override
    public boolean supportsArrayColumns() {
        return true;
    }
}

