/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseH2
extends DatabaseHelper {
    public static final DatabaseHelper INSTANCE = new DatabaseH2();
    private static final Log log = LogFactory.getLog(DatabaseH2.class);
    protected static final String DIRECTORY = "target";
    protected static final String DEF_USER = "sa";
    protected static final String DEF_PASSWORD = "";
    protected static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-h2-contrib.xml";
    protected static final String DRIVER = "org.h2.Driver";
    protected static final String URL_FORMAT = "jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1";
    protected String url;
    protected String url2;
    protected String user;
    protected String password;

    protected void setProperties() {
        this.url = DatabaseH2.setProperty("nuxeo.test.vcs.url", String.format(URL_FORMAT, this.databaseName));
        DatabaseH2.setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseH2.setProperty("nuxeo.test.vcs.database", this.databaseName);
        this.user = DatabaseH2.setProperty("nuxeo.test.vcs.user", DEF_USER);
        this.password = DatabaseH2.setProperty("nuxeo.test.vcs.password", DEF_PASSWORD);
        DatabaseH2.setProperty("nuxeo.test.vcs.driver", DRIVER);
    }

    protected void setProperties2() {
        this.url2 = String.format(URL_FORMAT, this.databaseName + "2");
        DatabaseH2.setProperty("nuxeo.test.vcs.url2", this.url2);
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository2", this.repositoryName + "2");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Class.forName(DRIVER);
        this.setProperties();
        this.checkDatabaseLive();
    }

    protected void checkDatabaseLive() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.url, Framework.getProperty((String)"nuxeo.test.vcs.user", (String)DEF_USER), Framework.getProperty((String)"nuxeo.test.vcs.password", null));
             Statement st = connection.createStatement();){
            st.execute("SELECT 1");
        }
    }

    public void setUp2() throws Exception {
        this.setProperties2();
    }

    protected String getId() {
        return "nuxeo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws SQLException {
        if (this.owner == null) {
            return;
        }
        try {
            this.tearDownDatabase(this.url);
            if (this.url2 != null) {
                this.tearDownDatabase(this.url2);
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownDatabase(String url) throws SQLException {
        try (Connection connection = DriverManager.getConnection(url, this.user, this.password);
             Statement st = connection.createStatement();){
            String sql = "SHUTDOWN";
            log.trace((Object)sql);
            st.execute(sql);
        }
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "org.h2.jdbcx.JdbcDataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("URL", this.url);
        properties.put("User", Framework.getProperty((String)"nuxeo.test.vcs.user"));
        properties.put("Password", Framework.getProperty((String)"nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

