/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseDB2
extends DatabaseHelper {
    private static final Log log = LogFactory.getLog(DatabaseDB2.class);
    public static DatabaseHelper INSTANCE = new DatabaseDB2();
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_PORT = "3700";
    private static final String DEFAULT_DATABASE_NAME = "nuxeotst";
    private static final String DEF_USER = "db2inst1";
    private static final String DEF_PASSWORD = "db2inst1pw99";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-db2-contrib.xml";
    private static final String DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String XA_DATASOURCE = "com.ibm.db2.jcc.DB2XADataSource";

    protected void setProperties() {
        this.databaseName = DEFAULT_DATABASE_NAME;
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseDB2.setProperty("nuxeo.test.vcs.database", this.databaseName);
        DatabaseDB2.setProperty("nuxeo.test.vcs.server", DEF_SERVER);
        DatabaseDB2.setProperty("nuxeo.test.vcs.port", DEF_PORT);
        DatabaseDB2.setProperty("nuxeo.test.vcs.user", DEF_USER);
        DatabaseDB2.setProperty("nuxeo.test.vcs.password", DEF_PASSWORD);
        DatabaseDB2.setProperty("nuxeo.test.vcs.driver", DRIVER);
        String url = String.format("jdbc:db2://%s:%s/%s", Framework.getProperty((String)"nuxeo.test.vcs.server"), Framework.getProperty((String)"nuxeo.test.vcs.port"), Framework.getProperty((String)"nuxeo.test.vcs.database"));
        DatabaseDB2.setProperty("nuxeo.test.vcs.url", url);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Class.forName(DRIVER);
        this.setProperties();
        Connection connection = DriverManager.getConnection(Framework.getProperty((String)"nuxeo.test.vcs.url"), Framework.getProperty((String)"nuxeo.test.vcs.user"), Framework.getProperty((String)"nuxeo.test.vcs.password"));
        DatabaseDB2.doOnAllTables(connection, null, Framework.getProperty((String)"nuxeo.test.vcs.user").toUpperCase(), "DROP TABLE \"%s\"");
        this.dropSequences(connection);
        connection.close();
    }

    public void dropSequences(Connection connection) throws Exception {
        ArrayList<String> sequenceNames = new ArrayList<String>();
        Statement st = connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT SEQUENCE_NAME FROM USER_SEQUENCES");
        while (rs.next()) {
            String sequenceName = rs.getString(1);
            if (sequenceName.indexOf(36) != -1) continue;
            sequenceNames.add(sequenceName);
        }
        rs.close();
        for (String sequenceName : sequenceNames) {
            String sql = String.format("DROP SEQUENCE \"%s\"", sequenceName);
            log.trace((Object)("SQL: " + sql));
            st.execute(sql);
        }
        st.close();
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = XA_DATASOURCE;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("URL", Framework.getProperty((String)"nuxeo.test.vcs.url"));
        properties.put("User", Framework.getProperty((String)"nuxeo.test.vcs.user"));
        properties.put("Password", Framework.getProperty((String)"nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

