/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver_Oracle
extends DriverRDB {
    public Driver_Oracle() {
        String myPackageName = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "Oracle";
        this.DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 250;
        this.INDEX_KEY_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.TABLE_NAME_LENGTH_MAX = 30;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = true;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/oracle.sql";
        this.m_psetClassName = myPackageName + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = myPackageName + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = myPackageName + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = myPackageName + ".SpecializedGraphReifier_RDB";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = true;
        this.setTableNames(this.TABLE_NAME_PREFIX);
    }

    @Override
    public void setConnection(IDBConnection dbcon) {
        this.m_dbcon = dbcon;
        try {
            DatabaseMetaData dmd = dbcon.getConnection().getMetaData();
            if (dmd == null) {
                throw new RDFRDBException("Oracle database metadata not available.");
            }
            this.TABLE_NAME_LENGTH_MAX = dmd.getMaxTableNameLength();
            this.setTableNames(this.TABLE_NAME_PREFIX);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Problem accessing Oracle database metadata.");
        }
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, dbcon, this.ID_SQL_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            logger.error("Unable to set connection for Driver:", (Throwable)e);
        }
    }

    @Override
    public int graphIdAlloc(String graphName) {
        Object result = null;
        int dbid = 0;
        try {
            String op = "insertGraph";
            dbid = this.getInsertID(this.GRAPH_TABLE);
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, this.GRAPH_TABLE);
            ps.setInt(1, dbid);
            ps.setString(2, graphName);
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
        return dbid;
    }

    @Override
    public void graphIdDealloc(int graphId) {
        Object result = null;
        try {
            String op = "deleteGraph";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(op, this.GRAPH_TABLE);
            ps.setInt(1, graphId);
            ps.executeUpdate();
            this.m_sql.returnPreparedSQLStatement(ps);
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to delete graph ID: " + e);
        }
    }

    protected void getTblParams(String[] param) {
        String headColType;
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        if (this.INDEX_KEY_LENGTH > 4000) {
            throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String objColType = "NVARCHAR2(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[0] = objColType;
        param[1] = headColType = "NVARCHAR2(" + this.INDEX_KEY_LENGTH + ")";
        param[2] = this.TABLE_NAME_PREFIX;
    }

    @Override
    protected String[] getCreateTableParams(int graphId, boolean isReif) {
        String[] parms = new String[3];
        String[] res = new String[2];
        this.getTblParams(parms);
        int tblCnt = this.getTableCount(graphId);
        res[0] = this.genTableName(graphId, tblCnt, isReif);
        res[1] = parms[0];
        return res;
    }

    @Override
    protected String[] getDbInitTablesParams() {
        String[] res = new String[3];
        this.getTblParams(res);
        this.EOS_LEN = this.EOS.length();
        return res;
    }

    @Override
    protected void setLongObjectHashAndTail(PreparedStatement ps, int argi, DriverRDB.RDBLongObject lobj) throws SQLException {
        int paramCount = ps.getParameterMetaData().getParameterCount();
        if (paramCount != 4) {
            logger.warn("Warning: Driver_Oracle: Mismatch in prepared statement paramter count: Expected 4 : Got: " + paramCount);
            logger.warn("Maybe running with an old (pre Jena2.5) etc/oracle.sql file?");
        }
        super.setLongObjectHashAndTail_Binary(ps, argi, lobj);
    }

    @Override
    public void clearSequences() {
        Iterator<String> seqIt = this.getSequences().iterator();
        while (seqIt.hasNext()) {
            this.removeSequence(seqIt.next());
        }
    }

    @Override
    protected List<String> getAllTables() {
        try {
            String sql = "SELECT TNAME AS TABLE_NAME FROM tab WHERE TNAME LIKE '" + this.TABLE_NAME_PREFIX + "%'";
            ResultSet rs = this.m_dbcon.getConnection().createStatement().executeQuery(sql);
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            rs.close();
            return tables;
        }
        catch (SQLException e1) {
            throw new RDFRDBException("Internal SQL error in driver - " + e1);
        }
    }

    @Override
    public String genSQLStringMatchLHS_IC(String var) {
        return "UPPER(" + var + ")";
    }

    @Override
    public String genSQLStringMatchRHS_IC(String strToMatch) {
        return "UPPER(" + strToMatch + ")";
    }

    @Override
    public String stringMatchEscapeChar() {
        return "\\";
    }

    @Override
    public String genSQLStringMatchEscape() {
        return " " + this.genSQLEscapeKW() + " '" + this.stringMatchEscapeChar() + "'";
    }
}

