/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance.test;

import info.simplecloud.core.Group;
import info.simplecloud.core.Resource;
import info.simplecloud.core.User;
import info.simplecloud.core.exceptions.InvalidUser;
import info.simplecloud.core.exceptions.UnknownAttribute;
import info.simplecloud.core.exceptions.UnknownEncoding;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.ServiceProviderConfig;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.enteties.Wire;
import info.simplecloud.scimproxy.compliance.test.ResourceCache;
import info.simplecloud.scimproxy.compliance.test.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;

public class SortTest
extends Test {
    public SortTest(CSP csp, ResourceCache<User> userCache, ResourceCache<Group> groupCache) {
        super(csp, userCache, groupCache);
    }

    @Override
    public List<TestResult> run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        results.add(this.doSort("Sort users in ascending order in XML", new Header("Accept", "application/xml"), "ascending", "XML", "/Users", "userName"));
        results.add(this.doSort("Sort users in descending order in XML", new Header("Accept", "application/xml"), "descending", "XML", "/Users", "userName"));
        results.add(this.doSort("Sort groups in ascending order in XML", new Header("Accept", "application/xml"), "ascending", "XML", "/Groups", "displayName"));
        results.add(this.doSort("Sort groups in descending order in XML", new Header("Accept", "application/xml"), "descending", "XML", "/Groups", "displayName"));
        results.add(this.doSort("Sort users in ascending order in JSON", new Header("Accept", "application/json"), "ascending", "JSON", "/Users", "userName"));
        results.add(this.doSort("Sort users in descending order in JSON", new Header("Accept", "application/json"), "descending", "JSON", "/Users", "userName"));
        results.add(this.doSort("Sort groups in ascending order in JSON", new Header("Accept", "application/json"), "ascending", "JSON", "/Groups", "displayName"));
        results.add(this.doSort("Sort groups in descending order in JSON", new Header("Accept", "application/json"), "descending", "JSON", "/Groups", "displayName"));
        return results;
    }

    private TestResult doSort(String testName, Header accept, String order, String encoding, String endpoint, String attribute) {
        ServiceProviderConfig spc = this.csp.getSpc();
        if (!spc.hasXmlDataFormat() && "xml".equals(encoding)) {
            return new TestResult(2, testName, "ServiceProvider does not support XML.", Wire.EMPTY);
        }
        GetMethod method = new GetMethod(this.csp.getUrl() + this.csp.getVersion() + endpoint + String.format("?sortBy=%s&sortOrder=%s", attribute, order));
        ComplienceUtils.configureMethod((HttpMethod)method);
        method.setRequestHeader(accept);
        HttpClient client = ComplienceUtils.getHttpClientWithAuth(this.csp, (HttpMethodBase)method);
        String resourcesString = "<no responce>";
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                return new TestResult(0, testName, "Failed. Server did not respond with 200 OK.", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
            }
            resourcesString = method.getResponseBodyAsString();
            List<Resource> resourcesList = "userName".equals(attribute) ? User.getUsers(resourcesString, encoding) : Group.getGroups(resourcesString, encoding);
            if (resourcesList.size() == 0) {
                return new TestResult(0, testName, "Failed. No resource in responce", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
            }
            Resource previous = resourcesList.get(0);
            for (int i = 1; i < resourcesList.size(); ++i) {
                Resource current = resourcesList.get(i);
                String previousValue = (String)previous.getAttribute(attribute);
                String currentValue = (String)current.getAttribute(attribute);
                if ("ascending".equals(order) && previousValue.compareTo(currentValue) > 0 || "descending".equals(order) && previousValue.compareTo(currentValue) < 0) {
                    return new TestResult(0, testName, "Failed. resources where not in expected order after sort", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
                }
                previous = current;
            }
        }
        catch (HttpException e) {
            return new TestResult(0, testName, "Failed, http error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (IOException e) {
            return new TestResult(0, testName, "Failed, io error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (UnknownEncoding e) {
            return new TestResult(0, testName, "Failed, encoding error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (InvalidUser e) {
            return new TestResult(0, testName, "Failed, scim resource error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (UnknownAttribute e) {
            return new TestResult(0, testName, "Failed, internal error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (Exception e) {
            return new TestResult(0, testName, "Failed, internal error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        return new TestResult(1, testName, "", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
    }
}

