/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance.test;

import info.simplecloud.core.Group;
import info.simplecloud.core.Resource;
import info.simplecloud.core.User;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.enteties.Wire;
import info.simplecloud.scimproxy.compliance.test.ResourceCache;
import info.simplecloud.scimproxy.compliance.test.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class PutTest
extends Test {
    public PutTest(CSP csp, ResourceCache<User> cache, ResourceCache<Group> groupCache) {
        super(csp, cache, groupCache);
    }

    @Override
    public List<TestResult> run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        User user = (User)this.userCache.borrowCachedResource();
        if (user != null) {
            user.setDisplayName("Bob");
        }
        results.add(this.putUser(user, "PUT User JSON", "/Users/", "json"));
        if (user != null) {
            user.setDisplayName("Bobert");
        }
        results.add(this.putUser(user, "PUT User XML", "/Users/", "xml"));
        Group group = (Group)this.groupCache.borrowCachedResource();
        if (group != null) {
            group.setDisplayName("TheTeam");
        }
        results.add(this.put(group, "PUT Group JSON", "/Groups/", "json"));
        if (group != null) {
            group.setDisplayName("2ndTeam");
        }
        results.add(this.put(group, "PUT Group XML", "/Groups/", "xml"));
        return results;
    }

    private TestResult put(Resource resource, String test, String path, String encoding) {
        if (resource == null) {
            return new TestResult(0, test, "No resource was created, can't do PUT.", Wire.EMPTY);
        }
        if (!this.csp.getSpc().hasXmlDataFormat() && "xml".equals(encoding)) {
            return new TestResult(2, test, "ServiceProvider does not support XML.", Wire.EMPTY);
        }
        if (resource instanceof Group) {
            return this.putGroup((Group)resource, test, path, encoding);
        }
        if (resource instanceof User) {
            return this.putUser((User)resource, test, path, encoding);
        }
        return null;
    }

    private TestResult putGroup(Group group, String test, String path, String encoding) {
        Group responsegroup;
        String responseBody;
        if (group == null) {
            return new TestResult(0, test, "No resource was created, can't do PUT.", Wire.EMPTY);
        }
        PutMethod method = this.getMethod(group, path, encoding);
        StringRequestEntity body = null;
        try {
            body = new StringRequestEntity(group.getGroup(encoding), "application/" + encoding, "UTF-8");
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. " + e.getMessage(), ComplienceUtils.getWire(e));
        }
        try {
            responseBody = this.doPut(test, method, body);
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        try {
            responsegroup = new Group(responseBody, encoding);
            group.getMeta().setVersion(responsegroup.getMeta().getVersion());
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. Could not parse group. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        if (!group.getDisplayName().equals(responsegroup.getDisplayName())) {
            return new TestResult(0, test, "Failed. Server responded with a different display name.", ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        return new TestResult(1, test, "", ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
    }

    private TestResult putUser(User user, String test, String path, String encoding) {
        User responseUser;
        String responseBody;
        if (user == null) {
            return new TestResult(0, test, "No resource was created, can't do PUT.", Wire.EMPTY);
        }
        PutMethod method = this.getMethod(user, path, encoding);
        StringRequestEntity body = null;
        try {
            body = new StringRequestEntity(user.getUser(encoding), "application/" + encoding, "UTF-8");
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. " + e.getMessage(), ComplienceUtils.getWire(e));
        }
        try {
            responseBody = this.doPut(test, method, body);
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        try {
            responseUser = new User(responseBody, encoding);
            user.getMeta().setVersion(responseUser.getMeta().getVersion());
        }
        catch (Exception e) {
            return new TestResult(0, test, "Failed. Could not parse user. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        if (!user.getDisplayName().equals(responseUser.getDisplayName())) {
            return new TestResult(0, test, "Failed. Server responded with a different display name.", ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
        }
        return new TestResult(1, test, "", ComplienceUtils.getWire((HttpMethodBase)method, body.getContent()));
    }

    private String doPut(String test, PutMethod method, StringRequestEntity body) throws Exception {
        int code;
        method.setRequestEntity((RequestEntity)body);
        HttpClient client = ComplienceUtils.getHttpClientWithAuth(this.csp, (HttpMethodBase)method);
        try {
            code = client.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        String responseBody = null;
        try {
            responseBody = method.getResponseBodyAsString();
        }
        catch (IOException e) {
            responseBody = "";
        }
        if (code != 200) {
            throw new Exception(responseBody);
        }
        return responseBody;
    }

    private PutMethod getMethod(Resource resource, String path, String encoding) {
        PutMethod method = new PutMethod(this.csp.getUrl() + this.csp.getVersion() + path + resource.getId());
        ComplienceUtils.configureMethod((HttpMethod)method);
        method.setRequestHeader(new Header("Accept", "application/" + encoding));
        if (resource.getMeta() != null && !resource.getMeta().getVersion().isEmpty()) {
            method.setRequestHeader(new Header("If-Match", resource.getMeta().getVersion()));
        }
        return method;
    }
}

