/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance.test;

import info.simplecloud.core.Group;
import info.simplecloud.core.Resource;
import info.simplecloud.core.User;
import info.simplecloud.core.exceptions.InvalidUser;
import info.simplecloud.core.exceptions.UnknownEncoding;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.test.ResourceCache;
import info.simplecloud.scimproxy.compliance.test.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Assert;

public class PostTest
extends Test {
    public PostTest(CSP csp, ResourceCache<User> userCache, ResourceCache<Group> groupCache) {
        super(csp, userCache, groupCache);
    }

    @Override
    public List<TestResult> run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        User scimUser = new User();
        Group scimGroup = new Group();
        User scimUserFull = ComplienceUtils.getUser();
        long nanoTime = System.nanoTime();
        scimUser.setUserName("J" + nanoTime);
        results.add(this.create("json", scimUser, false));
        scimUser.setUserName("Js" + nanoTime);
        results.add(this.create("json", scimUser, true));
        scimUserFull.setUserName("Jso" + nanoTime);
        results.add(this.create("json", scimUserFull, false));
        scimGroup.setDisplayName("ScimGroupJson");
        results.add(this.create("json", scimGroup, false));
        if (this.csp.getSpc().hasXmlDataFormat()) {
            scimUser.setUserName("X" + nanoTime);
            results.add(this.create("xml", scimUser, false));
            scimUser.setUserName("Xm" + nanoTime);
            results.add(this.create("xml", scimUser, true));
            scimUserFull.setUserName("Xml" + nanoTime);
            results.add(this.create("xml", scimUserFull, false));
            scimGroup.setDisplayName("ScimGroupXml");
            results.add(this.create("xml", scimGroup, false));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TestResult create(String enc, Resource resource, boolean useUrlToSetAcceptContentType) {
        String resourceString = null;
        String endpoint = null;
        PostMethod method = null;
        HttpClient client = null;
        String resourceType = "";
        try {
            Resource tmp;
            if (resource instanceof User) {
                tmp = (User)resource;
                resourceString = ((User)tmp).getUser(enc);
                endpoint = this.csp.getUrl() + this.csp.getVersion() + "/Users";
                resourceType = "user";
            } else if (resource instanceof Group) {
                tmp = (Group)resource;
                resourceString = ((Group)tmp).getGroup(enc);
                endpoint = this.csp.getUrl() + this.csp.getVersion() + "/Groups";
                resourceType = "group";
            }
            if (useUrlToSetAcceptContentType) {
                endpoint = endpoint + "." + enc.toLowerCase();
            }
            method = new PostMethod(endpoint);
            client = ComplienceUtils.getHttpClientWithAuth(this.csp, (HttpMethodBase)method);
            ComplienceUtils.configureMethod((HttpMethod)method);
            if ("xml".equalsIgnoreCase(enc)) {
                if (!useUrlToSetAcceptContentType) {
                    method.setRequestHeader(new Header("Accept", "application/xml"));
                }
                method.setRequestHeader(new Header("Content-Type", "application/xml"));
            } else {
                if (!useUrlToSetAcceptContentType) {
                    method.setRequestHeader(new Header("Accept", "application/json"));
                }
                method.setRequestHeader(new Header("Content-Type", "application/json"));
            }
            method.setRequestBody(resourceString);
            int statusCode = client.executeMethod((HttpMethod)method);
            byte[] responseBody = method.getResponseBody();
            String serverResp = new String(responseBody);
            if (statusCode == 201) {
                Object group;
                Resource cspResource = null;
                if (resource instanceof User) {
                    User user = new User(serverResp, enc);
                    this.userCache.addCachedResource(user);
                    cspResource = user;
                } else if (resource instanceof Group) {
                    group = new Group(new String(responseBody), enc);
                    this.groupCache.addCachedResource(group);
                    cspResource = group;
                }
                try {
                    this.verify(cspResource);
                    group = new TestResult(1, "Create " + resourceType + " in " + enc, "", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return group;
                }
                catch (Exception e) {
                    TestResult testResult;
                    block32: {
                        testResult = new TestResult(0, "Create " + resourceType + " in " + enc, e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                        if (method == null) break block32;
                        method.releaseConnection();
                    }
                    return testResult;
                }
            }
            TestResult testResult = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Server did not respond with 201.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
            return testResult;
            {
                TestResult testResult2;
                catch (HttpException e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Fatal http protocol violation.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (IOException e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Fatal http transport violation.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (UnknownEncoding e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Returned unknown encoding.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (InvalidUser e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Failed to parse resource.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (Exception e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Unknown error.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (AssertionError e) {
                    testResult2 = new TestResult(0, "Create " + resourceType + " in " + enc, "Failed. Assertion error.", ComplienceUtils.getWire((HttpMethodBase)method, resourceString));
                    return testResult2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void verify(Resource r) throws AssertionError {
        Assert.assertNotNull((String)"Missing resource", (Object)r);
        Assert.assertNotNull((String)"Missing id", (Object)r.getId());
        Assert.assertNotNull((String)"Missing metadata", (Object)r.getMeta());
        Assert.assertNotNull((String)"Missing metadata location", (Object)r.getMeta().getLocation());
    }
}

