/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance.test;

import info.simplecloud.core.Group;
import info.simplecloud.core.User;
import info.simplecloud.core.exceptions.UnknownAttribute;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.enteties.Wire;
import info.simplecloud.scimproxy.compliance.test.ResourceCache;
import info.simplecloud.scimproxy.compliance.test.Test;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;

public class DeleteTest
extends Test {
    public DeleteTest(CSP csp, ResourceCache<User> userCache, ResourceCache<Group> groupCache) {
        super(csp, userCache, groupCache);
    }

    @Override
    public List<TestResult> run() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        try {
            while (this.userCache.size() > 0) {
                User cachedUser = (User)this.userCache.removeCachedResource();
                results.add(this.delete(cachedUser.getId(), (String)cachedUser.getAttribute("meta.version"), "/Users/", "Delete user", 200));
                results.add(this.delete(cachedUser.getId(), (String)cachedUser.getAttribute("meta.version"), "/Users/", "Delete non-existing user", 404));
            }
            while (this.groupCache.size() > 0) {
                Group cachedGroup = (Group)this.groupCache.removeCachedResource();
                results.add(this.delete(cachedGroup.getId(), (String)cachedGroup.getAttribute("meta.version"), "/Groups/", "Delete group", 200));
                results.add(this.delete(cachedGroup.getId(), (String)cachedGroup.getAttribute("meta.version"), "/Groups/", "Delete non-existing group", 404));
            }
        }
        catch (UnknownAttribute e) {
            results.add(new TestResult(0, "Delete tests failed", "Failed, internal error: " + e.getMessage(), Wire.EMPTY));
        }
        return results;
    }

    private TestResult delete(String id, String etag, String path, String testName, int expectedCode) {
        DeleteMethod method = new DeleteMethod(this.csp.getUrl() + this.csp.getVersion() + path + id);
        ComplienceUtils.configureMethod((HttpMethod)method);
        method.setRequestHeader(new Header("Accept", "application/json"));
        method.setRequestHeader(new Header("If-Match", etag));
        HttpClient client = ComplienceUtils.getHttpClientWithAuth(this.csp, (HttpMethodBase)method);
        String resourcesString = "<no resource>";
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != expectedCode) {
                return new TestResult(0, testName, "Failed. Server did not respond with " + expectedCode + ".", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
            }
            resourcesString = method.getResponseBodyAsString();
        }
        catch (HttpException e) {
            return new TestResult(0, testName, "Failed, http error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        catch (IOException e) {
            return new TestResult(0, testName, "Failed, io error: " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
        }
        return new TestResult(1, testName, "", ComplienceUtils.getWire((HttpMethodBase)method, resourcesString));
    }
}

