/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance.test;

import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.ComplienceUtils;
import info.simplecloud.scimproxy.compliance.Schema;
import info.simplecloud.scimproxy.compliance.ServiceProviderConfig;
import info.simplecloud.scimproxy.compliance.enteties.AuthMetod;
import info.simplecloud.scimproxy.compliance.enteties.TestResult;
import info.simplecloud.scimproxy.compliance.exception.CritialComplienceException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConfigTest {
    public TestResult getConfiguration(CSP csp) throws Exception {
        String configuration;
        String url = csp.getUrl() + csp.getVersion() + "/ServiceProviderConfigs";
        GetMethod method = null;
        method = new GetMethod(url);
        HttpClient client = ComplienceUtils.getHttpClientWithAuth(csp, (HttpMethodBase)method);
        ComplienceUtils.configureMethod((HttpMethod)method);
        method.setRequestHeader(new Header("Accept", "application/json"));
        method.setRequestHeader(new Header("Content-Type", "application/json"));
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            configuration = method.getResponseBodyAsString();
            if (statusCode != 200) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new CritialComplienceException(new TestResult(0, "Read ServiceProviderConfig", "Could not get ServiceProviderConfig at url " + url, ComplienceUtils.getWire((HttpMethodBase)method, "")));
        }
        try {
            ServiceProviderConfig spc = new ServiceProviderConfig();
            JSONObject jsonObj = new JSONObject(configuration);
            JSONObject tmp = jsonObj.optJSONObject("patch");
            spc.setPatch(tmp == null ? false : tmp.getBoolean("supported"));
            tmp = jsonObj.optJSONObject("bulk");
            spc.setBulk(tmp == null ? false : tmp.optBoolean("supported"));
            spc.setBulkMaxOperations(tmp == null ? -1 : tmp.optInt("maxOperations"));
            spc.setBulkMaxPayloadSize(tmp == null ? -1 : tmp.optInt("maxPayloadSize"));
            tmp = jsonObj.optJSONObject("filter");
            spc.setFilter(tmp == null ? false : tmp.optBoolean("supported"));
            spc.setFilderMaxResults(tmp == null ? -1 : tmp.optInt("maxResults"));
            tmp = jsonObj.optJSONObject("changePassword");
            spc.setChangePassword(tmp == null ? false : tmp.optBoolean("supported"));
            tmp = jsonObj.optJSONObject("sort");
            spc.setSort(tmp == null ? false : tmp.getBoolean("supported"));
            tmp = jsonObj.optJSONObject("etag");
            spc.setEtag(tmp == null ? false : tmp.getBoolean("supported"));
            tmp = jsonObj.optJSONObject("xmlDataFormat");
            spc.setXmlDataFormat(tmp == null ? false : tmp.getBoolean("supported"));
            JSONArray authArray = jsonObj.getJSONArray("authenticationSchemes");
            for (int i = 0; i < authArray.length(); ++i) {
                tmp = authArray.getJSONObject(i);
                String name = tmp.optString("name");
                if (name == null) continue;
                spc.addAuthenticationScheme(AuthMetod.getMetod(name));
            }
            spc.addAuthenticationScheme(AuthMetod.getMetod("raw"));
            csp.setSpc(spc);
            return new TestResult(1, "Read ServiceProviderConfig", "", ComplienceUtils.getWire((HttpMethodBase)method, ""));
        }
        catch (Exception e) {
            throw new CritialComplienceException(new TestResult(0, "Parse ServiceProviderConfig", "Could not parse the json format returned from ServiceProviderConfig. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, "")));
        }
    }

    public TestResult getSchema(String type, CSP csp) throws Exception {
        String configuration;
        String url = csp.getUrl() + csp.getVersion() + "/Schemas/" + type;
        GetMethod method = null;
        method = new GetMethod(url);
        HttpClient client = ComplienceUtils.getHttpClientWithAuth(csp, (HttpMethodBase)method);
        ComplienceUtils.configureMethod((HttpMethod)method);
        method.setRequestHeader(new Header("Accept", "application/json"));
        method.setRequestHeader(new Header("Content-Type", "application/json"));
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            configuration = method.getResponseBodyAsString();
            if (statusCode != 200) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new CritialComplienceException(new TestResult(0, "Get schema for " + type, "Could not get " + type + " Schema at url " + url, ComplienceUtils.getWire((HttpMethodBase)method, "")));
        }
        try {
            Schema schema = new Schema();
            JSONObject jsonObj = new JSONObject(configuration);
            JSONArray jsonArray = jsonObj.getJSONArray("attributes");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject authObj = (JSONObject)jsonArray.get(i);
                if (!authObj.getBoolean("required")) continue;
                schema.addItem(authObj.getString("name"));
            }
            if ("Users".equalsIgnoreCase(type)) {
                csp.setUserSchema(schema);
            } else {
                csp.setGroupSchema(schema);
            }
            return new TestResult(1, "Read schema for " + type, "", ComplienceUtils.getWire((HttpMethodBase)method, ""));
        }
        catch (Exception e) {
            throw new CritialComplienceException(new TestResult(0, "Parse schema for " + type, "Could not parse the json format returned when getting " + type + " schema. " + e.getMessage(), ComplienceUtils.getWire((HttpMethodBase)method, "")));
        }
    }
}

