/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance;

import info.simplecloud.core.User;
import info.simplecloud.scimproxy.compliance.CSP;
import info.simplecloud.scimproxy.compliance.enteties.Wire;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ComplienceUtils {
    public static HttpClient getHttpClientWithAuth(CSP csp, HttpMethodBase method) {
        try {
            URL url = new URL(csp.getUrl());
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                int port = 443;
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
                Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), port));
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpClient client = new HttpClient();
        if ("basicAuth".equalsIgnoreCase(csp.getAuthentication())) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(csp.getUsername(), csp.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        if ("oauthAuth".equalsIgnoreCase(csp.getAuthentication())) {
            client.getParams().setAuthenticationPreemptive(false);
            method.setRequestHeader("Authorization", "Bearer " + csp.getAccessTokenUserPass());
        }
        if ("rawAuth".equalsIgnoreCase(csp.getAuthentication())) {
            client.getParams().setAuthenticationPreemptive(false);
            method.setRequestHeader("Authorization", csp.getAuthorizationHeader());
        }
        return client;
    }

    public static void configureMethod(HttpMethod method) {
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
    }

    public static String getVersionPath(CSP csp) {
        String versionPath = csp.getVersion();
        if (!"".equals(versionPath)) {
            versionPath = "/" + versionPath;
        }
        return versionPath;
    }

    public static User getUser() {
        try {
            String fullUser = FileUtils.readFileToString((File)new File("src/main/resources/user_full.json"));
            return new User(fullUser, "json");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Wire getWire(HttpMethodBase method, String body) {
        StringBuffer toServer = new StringBuffer();
        StringBuffer fromServer = new StringBuffer();
        toServer.append(method.getName()).append(" ");
        toServer.append(method.getPath());
        if (method.getQueryString() != null) {
            toServer.append("?").append(method.getQueryString());
        }
        toServer.append(" HTTP/1.1\n");
        for (Header header : method.getRequestHeaders()) {
            toServer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        toServer.append("\n" + body);
        try {
            fromServer.append(method.getStatusLine()).append("\n");
            for (Header header : method.getResponseHeaders()) {
                fromServer.append(header.getName()).append(": ").append(header.getValue()).append("\n");
            }
            fromServer.append("\n" + method.getResponseBodyAsString());
        }
        catch (IOException e) {
            fromServer.append("COULD NOT PARSE RESPONSE BODY\n");
            e.printStackTrace();
        }
        return new Wire(toServer.toString(), fromServer.toString());
    }

    public static Wire getWire(Throwable e) {
        return new Wire(ExceptionUtils.getFullStackTrace((Throwable)e), "");
    }
}

