/*
 * Decompiled with CFR 0.152.
 */
package info.simplecloud.scimproxy.compliance;

import info.simplecloud.scimproxy.compliance.Schema;
import info.simplecloud.scimproxy.compliance.ServiceProviderConfig;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class CSP {
    public static final String AUTH_OAUTH2 = "OAuth2";
    public static String AUTH_BASIC = "basic";
    private String id = "";
    private String url = "";
    private String authentication = "";
    private String username = "";
    private String password = "";
    private String oAuth2AccessToken = "";
    private String oAuth2AuthorizationServer = "";
    private String oAuth2ClientId = "";
    private String oAuth2ClientSecret = "";
    private String oAuth2GrantType = "";
    private String preferedEncoding = "JSON";
    private String version = "";
    private String overrideBehaviour = "";
    private String saveExternalId = "";
    private HashMap<String, String> resourceIdMapping = new HashMap();
    private HashMap<String, String> versionMapping = new HashMap();
    private ServiceProviderConfig spc = new ServiceProviderConfig();
    private Schema userSchema = new Schema();
    private Schema groupSchema = new Schema();
    private String authorizationHeader = "";

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setOAuth2AccessToken(String oAuth2AccessToken) {
        this.oAuth2AccessToken = oAuth2AccessToken;
    }

    public String getOAuth2AccessToken() {
        return this.oAuth2AccessToken;
    }

    public void setOAuth2AuthorizationServer(String oAuthAuthorizationServer) {
        this.oAuth2AuthorizationServer = oAuthAuthorizationServer;
    }

    public String getOAuthAuthorizationServer() {
        return this.oAuth2AuthorizationServer;
    }

    public void setPreferedEncoding(String preferedEncoding) {
        this.preferedEncoding = preferedEncoding;
    }

    public String getPreferedEncoding() {
        return this.preferedEncoding;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExternalIdForId(String resourceId) {
        return this.resourceIdMapping.get(resourceId);
    }

    public void setExternalIdForId(String resourceId, String externalId) {
        this.resourceIdMapping.put(resourceId, externalId);
    }

    public String getVersionForId(String resourceId) {
        return this.versionMapping.get(resourceId);
    }

    public void setVersionForId(String resourceId, String version) {
        this.versionMapping.put(resourceId, version);
    }

    public void setoAuth2ClientId(String oAuth2ClientId) {
        this.oAuth2ClientId = oAuth2ClientId;
    }

    public String getoAuth2ClientId() {
        return this.oAuth2ClientId;
    }

    public void setoAuth2ClientSecret(String oAuth2ClientSecret) {
        this.oAuth2ClientSecret = oAuth2ClientSecret;
    }

    public String getoAuth2ClientSecret() {
        return this.oAuth2ClientSecret;
    }

    public void setoAuth2GrantType(String oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType;
    }

    public String getoAuth2GrantType() {
        return this.oAuth2GrantType;
    }

    public String toString() {
        return "url=" + this.url + ", auth=" + this.authentication;
    }

    public String getAccessToken() {
        if (this.oAuth2AccessToken != null) {
            return this.oAuth2AccessToken;
        }
        try {
            HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
            client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            PostMethod method = new PostMethod(this.getOAuthAuthorizationServer());
            method.setRequestBody("grant_type=client_credentials");
            int responseCode = client.executeMethod((HttpMethod)method);
            if (responseCode != 200) {
                throw new RuntimeException("Failed to fetch access token form authorization server, " + this.getOAuthAuthorizationServer() + ", got response code " + responseCode);
            }
            String responseBody = method.getResponseBodyAsString();
            JSONObject accessResponse = new JSONObject(responseBody);
            accessResponse.getString("access_token");
            this.oAuth2AccessToken = accessResponse.getString("access_token");
            return this.oAuth2AccessToken;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read response from authorizationServer at " + this.getOAuthAuthorizationServer(), e);
        }
    }

    public String getAccessTokenUserPass() {
        if (!StringUtils.isEmpty((String)this.oAuth2AccessToken)) {
            return this.oAuth2AccessToken;
        }
        if (StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.password) && StringUtils.isEmpty((String)this.oAuth2AuthorizationServer) || StringUtils.isEmpty((String)this.oAuth2ClientId) || StringUtils.isEmpty((String)this.oAuth2ClientSecret)) {
            return "";
        }
        try {
            HttpClient client = new HttpClient();
            client.getParams().setAuthenticationPreemptive(true);
            PostMethod method = new PostMethod(this.getOAuthAuthorizationServer());
            method.setRequestHeader(new Header("Content-type", "application/x-www-form-urlencoded"));
            method.addRequestHeader("Authorization", "Basic " + Base64.encodeBase64String((this.username + ":" + this.password).getBytes()));
            NameValuePair[] body = new NameValuePair[]{new NameValuePair("username", this.username), new NameValuePair("password", this.password), new NameValuePair("client_id", this.oAuth2ClientId), new NameValuePair("client_secret", this.oAuth2ClientSecret), new NameValuePair("grant_type", this.oAuth2GrantType)};
            method.setRequestBody(body);
            int responseCode = client.executeMethod((HttpMethod)method);
            String responseBody = method.getResponseBodyAsString();
            if (responseCode != 200) {
                throw new RuntimeException("Failed to fetch access token form authorization server, " + this.getOAuthAuthorizationServer() + ", got response code " + responseCode);
            }
            JSONObject accessResponse = new JSONObject(responseBody);
            accessResponse.getString("access_token");
            this.oAuth2AccessToken = accessResponse.getString("access_token");
            return this.oAuth2AccessToken;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read response from authorizationServer at " + this.getOAuthAuthorizationServer(), e);
        }
    }

    public void setOverrideBehaviour(String overrideBehaviour) {
        this.overrideBehaviour = overrideBehaviour;
    }

    public String getOverrideBehaviour() {
        return this.overrideBehaviour;
    }

    public void setSaveExternalId(String saveExternalId) {
        this.saveExternalId = saveExternalId;
    }

    public String getSaveExternalId() {
        return this.saveExternalId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSpc(ServiceProviderConfig spc) {
        this.spc = spc;
    }

    public ServiceProviderConfig getSpc() {
        return this.spc;
    }

    public void setUserSchema(Schema userSchema) {
        this.userSchema = userSchema;
    }

    public Schema getUserSchema() {
        return this.userSchema;
    }

    public void setGroupSchema(Schema groupSchema) {
        this.groupSchema = groupSchema;
    }

    public Schema getGroupSchema() {
        return this.groupSchema;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }
}

