/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.extension.TextExtensionFragmentParser;
import org.apache.cxf.bus.extension.XmlExtensionFragmentParser;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ObjectTypeResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.SinglePropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManagerImpl
implements ExtensionManager,
ConfiguredBeanLocator {
    public static final Logger LOG = LogUtils.getL7dLogger(ExtensionManagerImpl.class);
    public static final String EXTENSIONMANAGER_PROPERTY_NAME = "extensionManager";
    public static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    public static final String ACTIVATION_NAMESPACES_SETTER_METHOD_NAME = "setActivationNamespaces";
    public static final String BUS_EXTENSION_RESOURCE_XML = "META-INF/cxf/bus-extensions.xml";
    public static final String BUS_EXTENSION_RESOURCE_OLD_XML = "bus-extensions.xml";
    public static final String BUS_EXTENSION_RESOURCE = "META-INF/cxf/bus-extensions.txt";
    private final ClassLoader loader;
    private ResourceManager resourceManager;
    private Map<String, Extension> all = new LinkedHashMap<String, Extension>();
    private final Map<Class<?>, Object> activated;
    private final Bus bus;

    public ExtensionManagerImpl(ClassLoader cl, Map<Class<?>, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{BUS_EXTENSION_RESOURCE, BUS_EXTENSION_RESOURCE_XML, BUS_EXTENSION_RESOURCE_OLD_XML}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String resource, ClassLoader cl, Map<Class<?>, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{resource}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String[] resources, ClassLoader cl, Map<Class<?>, Object> initialExtensions, ResourceManager rm, Bus b) {
        this.loader = cl;
        this.bus = b;
        this.activated = initialExtensions;
        this.resourceManager = rm;
        SinglePropertyResolver extensionManagerResolver = new SinglePropertyResolver(EXTENSIONMANAGER_PROPERTY_NAME, (Object)this);
        this.resourceManager.addResourceResolver((ResourceResolver)extensionManagerResolver);
        this.resourceManager.addResourceResolver((ResourceResolver)new ObjectTypeResolver((Object)this));
        this.load(resources);
    }

    public final synchronized void load(String[] resources) {
        if (resources == null) {
            return;
        }
        try {
            for (String resource : resources) {
                this.load(resource);
            }
        }
        catch (IOException ex) {
            throw new ExtensionException(ex);
        }
        for (Map.Entry<String, Extension> ext : ExtensionRegistry.getRegisteredExtensions().entrySet()) {
            if (this.all.containsKey(ext.getKey())) continue;
            this.all.put(ext.getKey(), ext.getValue());
        }
    }

    public synchronized void add(Extension ex) {
        this.all.put(ex.getName(), ex);
    }

    public synchronized void initialize() {
        for (Extension e : this.all.values()) {
            if (e.isDeferred() || e.getLoadedObject() != null) continue;
            this.loadAndRegister(e);
        }
    }

    public synchronized void removeBeansOfNames(List<String> names) {
        for (String s : names) {
            this.all.remove(s);
        }
    }

    @Override
    public synchronized void activateAll() {
        for (Extension e : this.all.values()) {
            if (e.getLoadedObject() != null) continue;
            this.loadAndRegister(e);
        }
    }

    @Override
    public synchronized <T> void activateAllByType(Class<T> type) {
        for (Extension e : this.all.values()) {
            Class<?> cls;
            if (e.getLoadedObject() != null || (cls = e.getClassObject(this.loader)) == null || !type.isAssignableFrom(cls)) continue;
            this.loadAndRegister(e);
        }
    }

    public boolean hasBeanOfName(String name) {
        return this.all.containsKey(name);
    }

    final void load(String resource) throws IOException {
        if (this.loader != this.getClass().getClassLoader()) {
            this.load(resource, this.getClass().getClassLoader());
        }
        this.load(resource, this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void load(String resource, ClassLoader l) throws IOException {
        Enumeration<URL> urls = l.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            try {
                List<Extension> exts;
                if (resource.endsWith("xml")) {
                    LOG.log(Level.WARNING, "DEPRECATED_EXTENSIONS", new Object[]{resource, url, BUS_EXTENSION_RESOURCE});
                    exts = new XmlExtensionFragmentParser().getExtensions(is);
                } else {
                    exts = new TextExtensionFragmentParser().getExtensions(is);
                }
                for (Extension e : exts) {
                    if (this.loader != l) {
                        e.classloader = l;
                    }
                    this.all.put(e.getName(), e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadAndRegister(Extension e) {
        Class<?> cls = null;
        if (null != e.getInterfaceName() && !"".equals(e.getInterfaceName())) {
            cls = e.loadInterface(this.loader);
        }
        if (null != this.activated && null != cls && null != this.activated.get(cls)) {
            return;
        }
        Object obj = e.load(this.loader, this.bus);
        Configurer configurer = (Configurer)this.activated.get(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(obj);
        }
        SinglePropertyResolver namespacesResolver = null;
        if (null != e.getNamespaces()) {
            namespacesResolver = new SinglePropertyResolver(ACTIVATION_NAMESPACES_PROPERTY_NAME, e.getNamespaces());
            this.resourceManager.addResourceResolver((ResourceResolver)namespacesResolver);
        }
        if (e.getNamespaces() != null && !e.getNamespaces().isEmpty()) {
            this.invokeSetterActivationNSMethod(obj, e.getNamespaces());
        }
        ResourceInjector injector = new ResourceInjector(this.resourceManager);
        try {
            injector.inject(obj);
            injector.construct(obj);
        }
        finally {
            if (null != namespacesResolver) {
                this.resourceManager.removeResourceResolver((ResourceResolver)namespacesResolver);
            }
        }
        if (null != this.activated) {
            if (cls == null) {
                cls = obj.getClass();
            }
            this.activated.put(cls, obj);
        }
    }

    @Override
    public synchronized <T> T getExtension(String name, Class<T> type) {
        Class<?> cls;
        Extension e = this.all.get(name);
        if (e != null && (cls = e.getClassObject(this.loader)) != null && type.isAssignableFrom(e.getClassObject(this.loader))) {
            if (e.getLoadedObject() == null) {
                this.loadAndRegister(e);
            }
            return type.cast(e.getLoadedObject());
        }
        return null;
    }

    private void invokeSetterActivationNSMethod(Object target, Object value) {
        String methodName = ACTIVATION_NAMESPACES_SETTER_METHOD_NAME;
        for (Class<?> clazz = target.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> paramType;
                Method method = methods[i];
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(methodName) || params.length != 1 || !(paramType = params[0]).isInstance(value)) continue;
                try {
                    method.invoke(target, value);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public List<String> getBeanNamesOfType(Class<?> type) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Extension ex : this.all.values()) {
            Class<?> cls = ex.getClassObject(this.loader);
            if (cls == null || !type.isAssignableFrom(cls)) continue;
            ret.add(ex.getName());
        }
        return ret;
    }

    public synchronized <T> T getBeanOfType(String name, Class<T> type) {
        Extension ex = this.all.get(name);
        if (ex != null) {
            if (ex.getLoadedObject() == null) {
                this.loadAndRegister(ex);
            }
            return type.cast(ex.getLoadedObject());
        }
        return null;
    }

    public synchronized <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        LinkedList<T> ret = new LinkedList<T>();
        for (Extension ex : this.all.values()) {
            Class<?> cls = ex.getClassObject(this.loader);
            if (cls == null || !type.isAssignableFrom(cls)) continue;
            if (ex.getLoadedObject() == null) {
                this.loadAndRegister(ex);
            }
            ret.add(type.cast(ex.getLoadedObject()));
        }
        return ret;
    }

    public synchronized <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        boolean loaded = false;
        for (Extension ex : this.all.values()) {
            Class<?> cls = ex.getClassObject(this.loader);
            if (cls == null || ex.getLoadedObject() != null || !type.isAssignableFrom(cls) || !listener.loadBean(ex.getName(), cls.asSubclass(type))) continue;
            this.loadAndRegister(ex);
            if (listener.beanLoaded(ex.getName(), type.cast(ex.getLoadedObject()))) {
                return true;
            }
            loaded = true;
        }
        return loaded;
    }

    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String value) {
        Extension ex = this.all.get(beanName);
        return ex != null && ex.getNamespaces() != null && ex.getNamespaces().contains(value);
    }

    public synchronized void destroyBeans() {
        for (Extension ex : this.all.values()) {
            if (ex.getLoadedObject() == null) continue;
            ResourceInjector injector = new ResourceInjector(this.resourceManager);
            injector.destroy(ex.getLoadedObject());
        }
    }
}

