/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.Projection", category="Services", label="Get a Directory Projection", since="5.7.2", description="Executes a query using given filter and return only the column *<b>columnName</b>*. The result is assigned to the context variable *<b>variableName</b>*. The filters are specified as <i>key=value</i> pairs separated by a new line. The key used for a filter is the column name of the directory. To specify multi-line values you can use a \\ character followed by a new line. <p>Example:<pre>firstName=John<br>lastName=doe</pre>By default, the search filters use exact match. You can do a fulltext search on some specific columns using the fulltextFields. it's specified as comma separated columnName, for instance : <p>Example:<pre>firstName,lastName</pre>", addToStudio=false)
public class DirectoryProjection {
    public static final String ID = "Directory.Projection";
    private static final Log log = LogFactory.getLog(DirectoryProjection.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="columnName", required=true)
    protected String columnName;
    @Param(name="variableName", required=true)
    protected String variableName;
    @Param(name="filters", required=false)
    protected Properties filterProperties;
    @Param(name="fulltextFields", required=false)
    protected StringList fulltextFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws Exception {
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        Session session = null;
        try {
            session = directory.getSession();
            HashMap filter = new HashMap();
            HashSet fulltext = new HashSet();
            if (this.filterProperties != null) {
                filter.putAll(this.filterProperties);
                if (this.fulltextFields != null) {
                    fulltext.addAll(this.fulltextFields);
                }
            }
            List uids = session.getProjection(filter, fulltext, this.columnName);
            this.ctx.put(this.variableName, (Object)uids);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (ClientException ce) {
                log.error((Object)"Could not close directory session", (Throwable)ce);
            }
        }
    }
}

