/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.token;

import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class TokenAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";
    private static final Log log = LogFactory.getLog(TokenAuthenticator.class);
    protected static final String TOKEN_HEADER = "X-Authentication-Token";

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return false;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String token = this.getTokenFromRequest(httpRequest);
        if (token == null) {
            log.debug((Object)String.format("Found no '%s' header in the request.", TOKEN_HEADER));
            return null;
        }
        String userName = this.getUserByToken(token);
        if (userName == null) {
            log.debug((Object)String.format("No user bound to the token '%s' (maybe it has been revoked), returning null.", token));
            return null;
        }
        return new UserIdentificationInfo(userName, userName);
    }

    private String getTokenFromRequest(HttpServletRequest httpRequest) {
        Cookie cookie;
        String token = httpRequest.getHeader(TOKEN_HEADER);
        if (token == null && httpRequest.getCookies() != null && (cookie = this.getTokenCookie(httpRequest)) != null && this.isAllowedToUseCookieToken(httpRequest)) {
            return cookie.getValue();
        }
        return token;
    }

    private Cookie getTokenCookie(HttpServletRequest httpRequest) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(TOKEN_HEADER) || !this.isAllowedToUseCookieToken(httpRequest)) continue;
                return cookie;
            }
        }
        return null;
    }

    private boolean isAllowedToUseCookieToken(HttpServletRequest req) {
        if (LOCALHOST.equals(req.getServerName())) {
            return true;
        }
        return HTTPS.equals(req.getScheme());
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return false;
    }

    public void initPlugin(Map<String, String> parameters) {
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    protected String getUserByToken(String token) {
        TokenAuthenticationService tokenAuthService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        return tokenAuthService.getUserName(token);
    }
}

