/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.query.api.PredicateDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;

public class PageProviderQueryBuilder {
    private PageProviderQueryBuilder() {
    }

    public static QueryBuilder makeQuery(String pattern, Object[] params, boolean quotePatternParameters, boolean escapePatternParameters, boolean useNativeQuery) {
        String query = pattern;
        if (params != null) {
            for (Object param : params) {
                query = query.replaceFirst("\\?", PageProviderQueryBuilder.convertParam(param, quotePatternParameters));
            }
        }
        if (useNativeQuery) {
            return QueryBuilders.queryString((String)query);
        }
        return NxqlQueryConverter.toESQueryBuilder(query);
    }

    public static QueryBuilder makeQuery(DocumentModel model, WhereClauseDefinition whereClause, Object[] params, boolean useNativeQuery) throws ClientException {
        assert (model != null);
        assert (whereClause != null);
        NxqlQueryConverter.ExpressionBuilder eb = new NxqlQueryConverter.ExpressionBuilder("AND");
        String fixedPart = whereClause.getFixedPart();
        if (params != null) {
            for (Object param : params) {
                fixedPart = fixedPart.replaceFirst("\\?", PageProviderQueryBuilder.convertParam(param, true));
            }
            if (useNativeQuery) {
                eb.add((QueryBuilder)QueryBuilders.queryString((String)fixedPart));
            } else {
                eb.add(NxqlQueryConverter.toESQueryBuilder(fixedPart));
            }
        }
        for (PredicateDefinition predicate : whereClause.getPredicates()) {
            Object[] values;
            PredicateFieldDefinition[] fieldDef = predicate.getValues();
            try {
                values = new Object[fieldDef.length];
                for (int fidx = 0; fidx < fieldDef.length; ++fidx) {
                    values[fidx] = fieldDef[fidx].getXpath() != null ? model.getPropertyValue(fieldDef[fidx].getXpath()) : model.getProperty(fieldDef[fidx].getSchema(), fieldDef[fidx].getName());
                }
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            if (!PageProviderQueryBuilder.isNonNullParam(values)) continue;
            Object value = values[0];
            if (values[0] instanceof Collection) {
                Collection vals = (Collection)values[0];
                values = vals.toArray(new Object[vals.size()]);
            } else if (values[0] instanceof Object[]) {
                values = (Object[])values[0];
            }
            String name = predicate.getParameter();
            String operator = predicate.getOperator().toUpperCase();
            if ("FULLTEXT".equals(operator) || "FULLTEXT ALL".equals(operator)) {
                operator = "=";
                if (!name.startsWith("ecm:fulltext")) {
                    name = "ecm:fulltext." + name;
                }
            }
            eb.add(NxqlQueryConverter.makeQueryFromSimpleExpression(operator, name, value, values));
        }
        return eb.get();
    }

    protected static String convertParam(Object param, boolean quote) {
        String ret;
        if (param == null) {
            ret = "";
        } else if (param instanceof List) {
            StringBuilder stringBuilder = new StringBuilder("");
            NXQLQueryBuilder.appendStringList((StringBuilder)stringBuilder, (List)((List)param), (boolean)quote, (boolean)true);
            ret = stringBuilder.toString();
            quote = false;
        } else {
            ret = param instanceof Calendar ? DateParser.formatW3CDateTime((Date)((Calendar)param).getTime()) : param.toString();
        }
        if (quote && param instanceof String) {
            ret = "\"" + ret + "\"";
        }
        return ret;
    }

    protected static boolean isNonNullParam(Object[] val) {
        if (val == null) {
            return false;
        }
        for (Object v : val) {
            if (v == null) continue;
            if (v instanceof String) {
                if (((String)v).isEmpty()) continue;
                return true;
            }
            if (v instanceof String[]) {
                if (((String[])v).length <= 0) continue;
                return true;
            }
            if (v instanceof Collection) {
                if (((Collection)v).isEmpty()) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

