/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;

public final class NxqlQueryConverter {
    private static final Log log = LogFactory.getLog(NxqlQueryConverter.class);
    private static final String SELECT_ALL = "SELECT * FROM Document";
    private static final String SELECT_ALL_WHERE = "SELECT * FROM Document WHERE ";
    private static final String SIMPLE_QUERY_PREFIX = "es: ";

    private NxqlQueryConverter() {
    }

    public static QueryBuilder toESQueryBuilder(String nxql) {
        final LinkedList<ExpressionBuilder> builders = new LinkedList<ExpressionBuilder>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        ExpressionBuilder ret = new ExpressionBuilder(null);
        builders.add(ret);
        final ArrayList fromList = new ArrayList();
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){
            private static final long serialVersionUID = 1L;

            public void visitQuery(SQLQuery node) {
                super.visitQuery(node);
            }

            public void visitFromClause(FromClause node) {
                FromList elements = node.elements;
                SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                for (int i = 0; i < elements.size(); ++i) {
                    String type = (String)elements.get(i);
                    if ("Document".equalsIgnoreCase(type)) {
                        fromList.clear();
                        return;
                    }
                    Set types = schemaManager.getDocumentTypeNamesExtending(type);
                    if (types == null) continue;
                    fromList.addAll(types);
                }
            }

            public void visitMultiExpression(MultiExpression node) {
                Iterator it = node.values.iterator();
                while (it.hasNext()) {
                    ((Operand)it.next()).accept((IVisitor)this);
                    if (!it.hasNext()) continue;
                    node.operator.accept((IVisitor)this);
                }
            }

            public void visitSelectClause(SelectClause node) {
            }

            public void visitExpression(Expression node) {
                Operator op = node.operator;
                if (op == Operator.AND || op == Operator.OR || op == Operator.NOT) {
                    builders.add(new ExpressionBuilder(op.toString()));
                    super.visitExpression(node);
                    ExpressionBuilder expr = (ExpressionBuilder)builders.removeLast();
                    if (!builders.isEmpty()) {
                        ((ExpressionBuilder)builders.getLast()).merge(expr);
                    }
                } else {
                    String value;
                    String name;
                    block7: {
                        Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
                        name = ref != null ? ref.name : node.lvalue.toString();
                        value = null;
                        try {
                            value = ((Literal)node.rvalue).asString();
                        }
                        catch (Throwable e) {
                            if (node.rvalue == null) break block7;
                            value = node.rvalue.toString();
                        }
                    }
                    Object[] values = null;
                    if (node.rvalue instanceof LiteralList) {
                        LiteralList items = (LiteralList)node.rvalue;
                        values = new Object[items.size()];
                        int i = 0;
                        for (Literal item : items) {
                            values[i++] = item.asString();
                        }
                    }
                    ((ExpressionBuilder)builders.getLast()).add(NxqlQueryConverter.makeQueryFromSimpleExpression(op.toString(), name, value, values));
                }
            }
        });
        QueryBuilder queryBuilder = ret.get();
        if (!fromList.isEmpty()) {
            return QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)NxqlQueryConverter.makeQueryFromSimpleExpression((String)"IN", (String)"ecm:primaryType", null, (Object[])fromList.toArray()).filter);
        }
        return queryBuilder;
    }

    protected static SQLQuery getSqlQuery(String nxql) {
        SQLQuery nxqlQuery;
        String query = NxqlQueryConverter.completeQueryWithSelect(nxql);
        try {
            nxqlQuery = SQLQueryParser.parse((Reader)new StringReader(query));
        }
        catch (QueryParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(e.getMessage() + " for query:\n" + query));
            }
            throw e;
        }
        return nxqlQuery;
    }

    protected static String completeQueryWithSelect(String nxql) {
        String query;
        String string = query = nxql == null ? "" : nxql.trim();
        if (query.isEmpty()) {
            query = SELECT_ALL;
        } else if (!query.toLowerCase().startsWith("select ")) {
            query = SELECT_ALL_WHERE + nxql;
        }
        return query;
    }

    public static QueryAndFilter makeQueryFromSimpleExpression(String op, String name, Object value, Object[] values) {
        Object query = null;
        Object filter = null;
        if ("ecm:isCheckedInVersion".equals(name)) {
            name = "ecm:isVersion";
        }
        if ((name = NxqlQueryConverter.getComplexFieldName(name)).startsWith("ecm:fulltext") && ("=".equals(op) || "!=".equals(op) || "<>".equals(op) || "LIKE".equals(op) || "NOT LIKE".equals(op))) {
            SimpleQueryStringBuilder.Operator defaultOperator;
            String field = name.replace("ecm:fulltext", "");
            field = field.startsWith(".") ? field.substring(1) + ".fulltext" : "_all";
            String queryString = (String)value;
            if (queryString.startsWith(SIMPLE_QUERY_PREFIX)) {
                queryString = queryString.substring(SIMPLE_QUERY_PREFIX.length());
                defaultOperator = SimpleQueryStringBuilder.Operator.OR;
            } else {
                defaultOperator = SimpleQueryStringBuilder.Operator.AND;
            }
            query = QueryBuilders.simpleQueryString((String)queryString).field(field).defaultOperator(defaultOperator).analyzer("fulltext");
            if ("!=".equals(op) || "<>".equals(op) || "NOT LIKE".equals(op)) {
                filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)query));
                query = null;
            }
        } else if ("=".equals(op)) {
            filter = FilterBuilders.termFilter((String)name, (Object)value);
        } else if ("<>".equals(op) || "!=".equals(op)) {
            filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (Object)value));
        } else if ("LIKE".equals(op) || "ILIKE".equals(op) || "NOT LIKE".equals(op) || "NOT ILIKE".equals(op)) {
            String likeValue = ((String)value).replace("%", "*");
            String fieldName = name;
            if (op.contains("ILIKE")) {
                likeValue = likeValue.toLowerCase();
                fieldName = name + ".lowercase";
            }
            query = StringUtils.countMatches((String)likeValue, (String)"*") == 1 && likeValue.endsWith("*") ? QueryBuilders.matchPhrasePrefixQuery((String)fieldName, (Object)likeValue.replace("*", "")) : QueryBuilders.wildcardQuery((String)fieldName, (String)likeValue);
            if (op.startsWith("NOT")) {
                filter = FilterBuilders.notFilter((FilterBuilder)FilterBuilders.queryFilter((QueryBuilder)query));
                query = null;
            }
        } else if ("BETWEEN".equals(op) || "NOT BETWEEN".equals(op)) {
            filter = FilterBuilders.rangeFilter((String)name).from(values[0]).to(values[1]);
            if ("NOT BETWEEN".equals(op)) {
                filter = FilterBuilders.notFilter((FilterBuilder)filter);
            }
        } else if ("IN".equals(op) || "NOT IN".equals(op)) {
            filter = FilterBuilders.inFilter((String)name, (Object[])values);
            if ("NOT IN".equals(op)) {
                filter = FilterBuilders.notFilter((FilterBuilder)filter);
            }
        } else if ("STARTSWITH".equals(op)) {
            filter = name.equals("ecm:path") ? FilterBuilders.termFilter((String)(name + ".children"), (Object)value) : FilterBuilders.prefixFilter((String)name, (String)((String)value));
        } else if (">".equals(op)) {
            filter = FilterBuilders.rangeFilter((String)name).gt(value);
        } else if ("<".equals(op)) {
            filter = FilterBuilders.rangeFilter((String)name).lt(value);
        } else if (">=".equals(op)) {
            filter = FilterBuilders.rangeFilter((String)name).gte(value);
        } else if ("<=".equals(op)) {
            filter = FilterBuilders.rangeFilter((String)name).lte(value);
        } else if ("IS NULL".equals(op)) {
            filter = FilterBuilders.missingFilter((String)name).nullValue(true);
        } else if ("IS NOT NULL".equals(op)) {
            filter = FilterBuilders.existsFilter((String)name);
        }
        return new QueryAndFilter((QueryBuilder)query, (FilterBuilder)filter);
    }

    protected static String getComplexFieldName(String name) {
        name = name.replace("/*", "");
        name = name.replace("/", ".");
        return name;
    }

    public static List<SortInfo> getSortInfo(String nxql) {
        final ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        SQLQuery nxqlQuery = NxqlQueryConverter.getSqlQuery(nxql);
        nxqlQuery.accept((IVisitor)new DefaultQueryVisitor(){
            private static final long serialVersionUID = 1L;

            public void visitOrderByExpr(OrderByExpr node) {
                sortInfos.add(new SortInfo(node.reference.name, !node.isDescending));
            }
        });
        return sortInfos;
    }

    public static class ExpressionBuilder {
        public final String operator;
        public QueryBuilder query;

        public ExpressionBuilder(String op) {
            this.operator = op;
            this.query = null;
        }

        public void add(QueryAndFilter qf) {
            if (qf != null) {
                this.add(qf.query, qf.filter);
            }
        }

        public void add(QueryBuilder q) {
            this.add(q, null);
        }

        public void add(QueryBuilder q, FilterBuilder f) {
            if (q == null && f == null) {
                return;
            }
            QueryBuilder inputQuery = q;
            if (inputQuery == null) {
                inputQuery = QueryBuilders.constantScoreQuery((FilterBuilder)f);
            }
            if (this.operator == null) {
                this.query = inputQuery;
            } else {
                if (this.query == null) {
                    this.query = QueryBuilders.boolQuery();
                }
                BoolQueryBuilder boolQuery = (BoolQueryBuilder)this.query;
                if ("AND".equals(this.operator)) {
                    boolQuery.must(inputQuery);
                } else if ("OR".equals(this.operator)) {
                    boolQuery.should(inputQuery);
                } else if ("NOT".equals(this.operator)) {
                    boolQuery.mustNot(inputQuery);
                }
            }
        }

        public void merge(ExpressionBuilder expr) {
            if (expr.operator != null && expr.operator.equals(this.operator) && this.query == null) {
                this.query = expr.query;
            } else {
                this.add(new QueryAndFilter(expr.query, null));
            }
        }

        public QueryBuilder get() {
            if (this.query == null) {
                return QueryBuilders.matchAllQuery();
            }
            return this.query;
        }

        public String toString() {
            return this.query.toString();
        }
    }

    public static class QueryAndFilter {
        public final QueryBuilder query;
        public final FilterBuilder filter;

        public QueryAndFilter(QueryBuilder query, FilterBuilder filter) {
            this.query = query;
            this.filter = filter;
        }
    }
}

