/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.listener;

import java.util.ArrayList;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchPostCommitSyncListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle bundle) throws ClientException {
        ArrayList<IndexingCommand> cmds = new ArrayList<IndexingCommand>();
        for (Event event : bundle) {
            if (!"ESIndexSyncTrigger".equals(event.getName())) continue;
            Map props = event.getContext().getProperties();
            for (String key : props.keySet()) {
                if (!key.startsWith("IndexingCommand-")) continue;
                IndexingCommand cmd = IndexingCommand.fromJSON(event.getContext().getCoreSession(), (String)props.get(key));
                cmds.add(cmd);
            }
        }
        if (!cmds.isEmpty()) {
            ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
            esi.indexNow(cmds);
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getLocalService(ElasticSearchAdmin.class);
            esa.refresh();
        }
    }
}

