/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.metrics.MetricsService;

public class ElasticsearchServiceImpl
implements ElasticSearchService {
    private static final Log log = LogFactory.getLog(ElasticsearchServiceImpl.class);
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Timer searchTimer;
    protected final Timer fetchTimer;
    private final ElasticSearchAdminImpl esa;

    public ElasticsearchServiceImpl(ElasticSearchAdminImpl esa) {
        this.esa = esa;
        this.searchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "search"}));
        this.fetchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "fetch"}));
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) throws ClientException {
        return this.queryAndAggregate(queryBuilder).getDocuments();
    }

    @Override
    public EsResult queryAndAggregate(NxQueryBuilder queryBuilder) throws ClientException {
        SearchResponse response = this.search(queryBuilder);
        DocumentModelListImpl docs = this.getDocumentModels(queryBuilder, response);
        List<Aggregate> aggs = this.getAggregates(queryBuilder, response);
        return new EsResult((DocumentModelList)docs, aggs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModelListImpl getDocumentModels(NxQueryBuilder queryBuilder, SearchResponse response) {
        DocumentModelListImpl ret;
        if (response.getHits().getHits().length == 0) {
            DocumentModelListImpl ret2 = new DocumentModelListImpl(0);
            ret2.setTotalSize(0L);
            return ret2;
        }
        Timer.Context stopWatch = this.fetchTimer.time();
        Fetcher fetcher = queryBuilder.getFetcher(response, this.esa.getRepositoryMap());
        try {
            ret = fetcher.fetchDocuments();
        }
        finally {
            stopWatch.stop();
        }
        long totalSize = response.getHits().getTotalHits();
        ret.setTotalSize(totalSize);
        return ret;
    }

    protected List<Aggregate> getAggregates(NxQueryBuilder queryBuilder, SearchResponse response) {
        for (AggregateEsBase<? extends Bucket> agg : queryBuilder.getAggregates()) {
            MultiBucketsAggregation mba;
            InternalFilter filter = (InternalFilter)response.getAggregations().get(NxQueryBuilder.getAggregateFilterId(agg));
            if (filter == null || (mba = (MultiBucketsAggregation)filter.getAggregations().get(agg.getId())) == null) continue;
            agg.parseEsBuckets(mba.getBuckets());
        }
        List<AggregateEsBase<? extends Bucket>> ret = queryBuilder.getAggregates();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse search(NxQueryBuilder query) {
        Timer.Context stopWatch = this.searchTimer.time();
        try {
            SearchRequestBuilder request = this.buildEsSearchRequest(query);
            this.logSearchRequest(request, query);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
        finally {
            stopWatch.stop();
        }
    }

    protected SearchRequestBuilder buildEsSearchRequest(NxQueryBuilder query) {
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(this.esa.getSearchIndexes(query.getSearchRepositories())).setTypes(new String[]{"doc"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        if (query.isFetchFromElasticsearch()) {
            request.setFetchSource(this.esa.getIncludeSourceFields(), this.esa.getExcludeSourceFields());
        } else {
            request.addField("_id");
        }
        query.updateRequest(request);
        return request;
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequestBuilder request, NxQueryBuilder query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getSearchIndexesAsString(query), "doc", request.toString()));
        }
    }

    protected String getSearchIndexesAsString(NxQueryBuilder query) {
        return StringUtils.join((Object[])this.esa.getSearchIndexes(query.getSearchRepositories()), (char)',');
    }
}

