/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class HistogramAggregate
extends AggregateEsBase<BucketRange> {
    private Integer interval;

    public HistogramAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public HistogramBuilder getEsAggregate() {
        HistogramBuilder ret = (HistogramBuilder)AggregationBuilders.histogram((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        ret.interval((long)this.getInterval());
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(Histogram.Order.COUNT_DESC);
                    break;
                }
                case "count asc": {
                    ret.order(Histogram.Order.COUNT_ASC);
                    break;
                }
                case "key desc": {
                    ret.order(Histogram.Order.KEY_DESC);
                    break;
                }
                case "key asc": {
                    ret.order(Histogram.Order.KEY_ASC);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        if (props.containsKey("extendedBoundsMax") && props.containsKey("extendedBoundsMin")) {
            ret.extendedBounds(Long.valueOf(Long.parseLong((String)props.get("extendedBoundsMin"))), Long.valueOf(Long.parseLong((String)props.get("extendedBoundsMax"))));
        }
        return ret;
    }

    @JsonIgnore
    public OrFilterBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        OrFilterBuilder ret = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
        for (String sel : this.getSelection()) {
            RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)this.getField());
            long from = Long.parseLong(sel);
            long to = from + (long)this.getInterval();
            rangeFilter.gte(from).lt(to);
            ret.add((FilterBuilder)rangeFilter);
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRange> nxBuckets = new ArrayList<BucketRange>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Histogram.Bucket histoBucket = (Histogram.Bucket)bucket;
            nxBuckets.add(new BucketRange(bucket.getKey(), histoBucket.getKeyAsNumber(), (Number)(histoBucket.getKeyAsNumber().intValue() + this.getInterval()), histoBucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }

    public int getInterval() {
        if (this.interval == null) {
            Map props = this.getProperties();
            if (props.containsKey("interval")) {
                this.interval = Integer.parseInt((String)props.get("interval"));
            } else {
                throw new IllegalArgumentException("interval property must be defined for " + this.toString());
            }
        }
        return this.interval;
    }
}

