/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.launcher.config.AbstractConfigurationTest;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

public class ConfigurationGeneratorTest
extends AbstractConfigurationTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FileUtils.copyDirectory((File)this.getResourceFile("templates/jboss"), (File)new File(this.nuxeoHome, "templates"));
        System.setProperty("jboss.home.dir", this.nuxeoHome.getPath());
    }

    @Test
    public void testEvalDynamicProperties() {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        Assert.assertEquals((String)"Bad loop back URL", (Object)"http://127.0.0.1:8080/nuxeo", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.loopback.url"));
        try {
            this.testAddress("10.213.2.105", "http://10.213.2.105:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
        log.debug((Object)"Force IPv6");
        System.setProperty("java.net.preferIPv4Stack", "false");
        System.setProperty("java.net.preferIPv6Addresses", "true");
        try {
            this.testAddress("::", "http://[0:0:0:0:0:0:0:1]:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
        try {
            this.testAddress("2a01:240:fe8e::226:bbff:fe09:55cd", "http://[2a01:240:fe8e:0:226:bbff:fe09:55cd]:8080/nuxeo");
        }
        catch (ConfigurationException e) {
            log.error((Object)e);
        }
    }

    private void testAddress(String bindAddress, String expectedLoopback) throws ConfigurationException {
        this.configGenerator.setProperty("nuxeo.bind.address", bindAddress);
        log.debug((Object)("Test with " + this.configGenerator.getUserConfig().getProperty("nuxeo.bind.address")));
        this.configGenerator.init(true);
        Assert.assertEquals((String)"Bad loop back URL", (Object)expectedLoopback, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.loopback.url"));
    }

    @Test
    public void testSetProperty() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String oldValue = this.configGenerator.setProperty("test.prop.key", "test.prop.value");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property not set", (Object)"test.prop.value", (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        oldValue = this.configGenerator.setProperty("test.prop.key", null);
        Assert.assertEquals((String)"Wrong old value", (Object)"test.prop.value", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        oldValue = this.configGenerator.setProperty("test.prop.key", "");
        Assert.assertEquals((String)"Wrong old value", null, (Object)oldValue);
        Assert.assertEquals((String)"Property must not be set", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
        this.configGenerator.setProperty("test.prop.key", "test.prop.value");
        oldValue = this.configGenerator.setProperty("test.prop.key", "");
        Assert.assertEquals((String)"Wrong old value", (Object)"test.prop.value", (Object)oldValue);
        Assert.assertEquals((String)"Property not unset", null, (Object)this.configGenerator.getUserConfig().getProperty("test.prop.key"));
    }

    @Test
    public void testAddRmTemplate() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        Assert.assertEquals((String)"Error calculating db template", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        this.configGenerator.addTemplate("newTemplate");
        Assert.assertEquals((String)"Error calculating db template", (Object)"postgresql", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        Assert.assertEquals((String)"newTemplate not added", (Object)(originalTemplates + ",newTemplate"), (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        this.configGenerator.rmTemplate("newTemplate");
        Assert.assertEquals((String)"Error calculating db template", (Object)"default", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
        Assert.assertEquals((String)"newTemplate not removed", (Object)originalTemplates, (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
    }

    @Test
    public void testSetWizardDone() throws ConfigurationException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        HashMap<String, String> changedParameters = new HashMap<String, String>();
        changedParameters.put("nuxeo.wizard.done", "true");
        this.configGenerator.saveFilteredConfiguration(changedParameters);
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        Assert.assertEquals((Object)"true", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.wizard.done"));
    }

    @Test
    public void testFreemarkerTemplate() throws ConfigurationException, IOException {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.addTemplate("fmtest");
        this.configGenerator.setProperty("test.freemarker.part1", "tr");
        this.configGenerator.setProperty("test.freemarker.part2", "ue");
        this.configGenerator.setProperty("test.freemarker.key", "${test.freemarker.part1}${test.freemarker.part2}");
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.run();
        File outfile = new File(this.nuxeoHome, "testfm");
        Assert.assertTrue((boolean)outfile.exists());
        String fileContents = FileUtils.readFileToString((File)outfile).trim();
        Assert.assertEquals((Object)fileContents, (Object)"Success");
    }

    @Test
    public void testChangeDatabase() throws Exception {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        this.configGenerator.changeDBTemplate("postgresql");
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)originalTemplates.replaceFirst("default", "postgresql"), (Object)this.configGenerator.getUserTemplates());
    }

    @Test
    public void testChangeDatabaseFromCustom() throws Exception {
        this.configGenerator = new ConfigurationGenerator();
        Assert.assertTrue((boolean)this.configGenerator.init());
        this.configGenerator.changeTemplates("testinclude2");
        String originalTemplates = this.configGenerator.getUserConfig().getProperty("nuxeo.templates");
        this.configGenerator.changeDBTemplate("postgresql");
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserTemplates());
        HashMap<String, String> customParameters = new HashMap<String, String>();
        customParameters.put("nuxeo.dbtemplate", "postgresql");
        this.configGenerator.saveFilteredConfiguration(customParameters);
        Assert.assertTrue((boolean)this.configGenerator.init(true));
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserTemplates());
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)(originalTemplates + ",postgresql"), (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.templates"));
        Assert.assertEquals((String)"Failed to change database default to postgresql", (Object)"postgresql", (Object)this.configGenerator.getUserConfig().getProperty("nuxeo.dbtemplate"));
    }
}

