/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.types;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Schema;

public class DocumentTypes {
    protected final DocumentType[] docTypes;
    protected Set<Schema> usedSchemas = null;

    public DocumentTypes(DocumentType[] docTypes) {
        this.docTypes = docTypes;
    }

    protected Set<Schema> getUsedSchemas() {
        if (this.usedSchemas == null) {
            this.usedSchemas = new HashSet<Schema>();
            for (DocumentType type : this.docTypes) {
                for (Schema schema : type.getSchemas()) {
                    this.usedSchemas.add(schema);
                }
            }
        }
        return this.usedSchemas;
    }

    public Schema[] getSchemas() {
        Set<Schema> schemas = this.getUsedSchemas();
        return schemas.toArray(new Schema[schemas.size()]);
    }

    public DocumentType[] getDocTypes() {
        return this.docTypes;
    }
}

