/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import org.javasimon.Split;
import org.nuxeo.ecm.core.management.jtajca.TransactionStatistics;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultTransactionMonitor;

public class DefaultTransactionStatistics
implements TransactionStatistics {
    protected final String id;
    protected long startTimestamp;
    protected Throwable startCapturedContext;
    protected String threadName;
    protected long endTimestamp;
    protected Throwable endCapturedContext;
    protected TransactionStatistics.Status status;
    protected Split split;

    protected DefaultTransactionStatistics(Object key) {
        this.id = DefaultTransactionMonitor.id(key);
    }

    @Override
    public String getId() {
        return this.id.toString();
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public TransactionStatistics.Status getStatus() {
        return this.status;
    }

    @Override
    public Date getStartDate() {
        return new Date(this.startTimestamp);
    }

    public String getStartCapturedContext() {
        return DefaultTransactionStatistics.printCapturedContext(this.startCapturedContext);
    }

    @Override
    public String getStartCapturedContextMessage() {
        return DefaultTransactionStatistics.printCapturedContext(this.startCapturedContext);
    }

    @Override
    public Date getEndDate() {
        return new Date(this.endTimestamp);
    }

    public Throwable getEndCapturedContext() {
        return this.endCapturedContext;
    }

    @Override
    public String getEndCapturedContextMessage() {
        if (this.endCapturedContext == null) {
            return "no context";
        }
        return DefaultTransactionStatistics.printCapturedContext(this.endCapturedContext);
    }

    @Override
    public long getDuration() {
        return this.endTimestamp - this.startTimestamp;
    }

    @Override
    public boolean isEnded() {
        return this.endTimestamp != 0L;
    }

    protected static String printCapturedContext(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter writer) {
        String date = DateFormat.getDateInstance(2).format(new Date(this.startTimestamp));
        long duration = this.getDuration();
        if (duration > 0L) {
            writer.write(String.format("Transaction has started at %s with a duration of %d ms and was in status %s\n%s", new Object[]{date, duration, this.status, this.getEndCapturedContextMessage()}));
        } else {
            writer.write(String.format("Transaction has started at %s and was in state %s\n%s", new Object[]{date, this.status, this.getStartCapturedContextMessage()}));
        }
        writer.flush();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw));
        return sw.toString();
    }
}

