/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.login.CallbackFactory;
import org.nuxeo.ecm.platform.login.CallbackFactoryDescriptor;
import org.nuxeo.ecm.platform.login.CallbackResult;
import org.nuxeo.ecm.platform.login.LoginPlugin;
import org.nuxeo.ecm.platform.login.LoginPluginDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class LoginPluginRegistry
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.login.LoginPluginRegistry");
    public static final String EP_PLUGIN = "plugin";
    public static final String EP_CBFACTORY = "callbackFactory";
    private static final Log log = LogFactory.getLog(LoginPluginRegistry.class);
    private LoginPlugin currentLoginPlugin = null;
    private Map<String, LoginPlugin> loginPluginStack;
    private CallbackFactory callbackFactory;
    private Map<String, LoginPluginDescriptor> pluginDescriptorStack;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(EP_PLUGIN)) {
            log.info((Object)"registering Login Plugin ... ");
            this.registerPlugin((LoginPluginDescriptor)contribution);
        } else if (extensionPoint.equals(EP_CBFACTORY)) {
            log.info((Object)"registering Callback factory ... ");
            this.registerCBFactory((CallbackFactoryDescriptor)contribution);
        } else {
            log.error((Object)("Extension point " + extensionPoint + " is unknown!"));
        }
    }

    private void registerCBFactory(CallbackFactoryDescriptor cbfExtension) {
        try {
            this.callbackFactory = (CallbackFactory)cbfExtension.getClassName().newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Unable to create Factory", (Throwable)e);
        }
    }

    private void registerPlugin(LoginPluginDescriptor pluginExtension) {
        Boolean enabled = pluginExtension.getEnabled();
        Class<LoginPlugin> className = pluginExtension.getClassName();
        String pluginName = pluginExtension.getPluginName();
        if (this.loginPluginStack.containsKey(pluginName)) {
            LoginPlugin oldLoginPlugin = this.loginPluginStack.get(pluginName);
            LoginPluginDescriptor oldLoginPluginDescriptor = this.pluginDescriptorStack.get(pluginName);
            Map<String, String> mergedParams = oldLoginPluginDescriptor.getParameters();
            mergedParams.putAll(pluginExtension.getParameters());
            oldLoginPlugin.setParameters(mergedParams);
            if (!oldLoginPlugin.initLoginModule().booleanValue()) {
                oldLoginPluginDescriptor.setInitialized(false);
                log.warn((Object)("Unable to initialize LoginPlugin for class " + className.getName()));
            } else {
                oldLoginPluginDescriptor.setInitialized(true);
            }
            if (enabled != null) {
                oldLoginPluginDescriptor.setEnabled(enabled);
            }
        } else {
            LoginPlugin newLoginPlugin = null;
            try {
                newLoginPlugin = className.newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Unable to create LoginPlugin for class " + className.getName() + ":" + e.getMessage()), (Throwable)e);
                return;
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Unable to create LoginPlugin for class " + className.getName() + ":" + e.getMessage()), (Throwable)e);
                return;
            }
            newLoginPlugin.setParameters(pluginExtension.getParameters());
            if (newLoginPlugin.initLoginModule().booleanValue()) {
                pluginExtension.setInitialized(true);
                log.info((Object)("LoginPlugin initialized for class " + className.getName()));
            } else {
                pluginExtension.setInitialized(false);
                log.warn((Object)("Unable to initialize LoginPlugin for class " + className.getName()));
            }
            this.pluginDescriptorStack.put(pluginName, pluginExtension);
            this.loginPluginStack.put(pluginName, newLoginPlugin);
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        this.currentLoginPlugin = null;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.loginPluginStack = new HashMap<String, LoginPlugin>();
        this.pluginDescriptorStack = new HashMap<String, LoginPluginDescriptor>();
    }

    @Deprecated
    public LoginPlugin getPlugin() {
        return this.currentLoginPlugin;
    }

    @Deprecated
    public Boolean useCustomLoginPlugin() {
        return this.currentLoginPlugin != null;
    }

    public CallbackResult handleSpecifcCallbacks(CallbackHandler callbackHandler) {
        if (this.callbackFactory == null) {
            return null;
        }
        return this.callbackFactory.handleSpecificCallbacks(callbackHandler);
    }

    public LoginPlugin getPlugin(String pluginName) {
        if (!this.pluginDescriptorStack.containsKey(pluginName)) {
            log.error((Object)("Unable to find needed Login Plugin : " + pluginName));
            return null;
        }
        LoginPlugin loginPlugin = this.loginPluginStack.get(pluginName);
        LoginPluginDescriptor loginPluginDescriptor = this.pluginDescriptorStack.get(pluginName);
        if (loginPlugin == null) {
            log.error((Object)("Login Plugin : " + pluginName + " is null "));
            return null;
        }
        if (!loginPluginDescriptor.getEnabled().booleanValue()) {
            log.error((Object)("Login Plugin : " + pluginName + " is not Enabled "));
            return null;
        }
        return loginPlugin;
    }

    public LoginPluginDescriptor getPluginDescriptor(String pluginName) {
        if (!this.pluginDescriptorStack.containsKey(pluginName)) {
            log.error((Object)("Unable to find needed Login Plugin : " + pluginName));
            return null;
        }
        LoginPlugin loginPlugin = this.loginPluginStack.get(pluginName);
        LoginPluginDescriptor loginPluginDescriptor = this.pluginDescriptorStack.get(pluginName);
        if (loginPlugin == null) {
            log.error((Object)("Login Plugin : " + pluginName + " is null "));
            return null;
        }
        if (!loginPluginDescriptor.getEnabled().booleanValue()) {
            log.error((Object)("Login Plugin : " + pluginName + " is not Enabled "));
            return null;
        }
        return loginPluginDescriptor;
    }
}

