/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser.token;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.token.SimpleTokenHandlerSessionHelper;
import org.apache.chemistry.opencmis.server.impl.browser.token.TokenHandler;

public abstract class AbstractSimpleTokenHandler
implements TokenHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TOKEN_BATCH_SIZE = 10;
    private static final String ATTR_PREFIX = "org.apache.chemistry.opencmis.";
    private static final String JSP_PATH = "/WEB-INF/token/";
    private static final String JSP_SCRIPT = "cmis.js.jsp";
    private static final String JSP_IFRAME = "repository.jsp";
    private static final String JSP_LOGIN = "login.jsp";
    private static final String PARAM_LOGIN = "login";
    private static final String LOGIN_SCRIPT = "script";
    private static final String LOGIN_CONTROLLER = "controller";
    private static final String LOGIN_LOGIN = "login";
    private static final String LOGIN_LOGOUT = "logout";
    private static final String LOGIN_TOKEN = "token";
    private static final UrlServiceCall URL_SERVICE_CALL = new UrlServiceCall();

    @Override
    public void service(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        block8: {
            String repositoryId = null;
            String login = request.getParameter("login");
            try {
                if (LOGIN_TOKEN.equals(login)) {
                    this.sendTokens(servletContext, request, response);
                    break block8;
                }
                if (LOGIN_SCRIPT.equals(login)) {
                    this.sendJavaScript(servletContext, request, response, repositoryId);
                    break block8;
                }
                if (LOGIN_CONTROLLER.equals(login)) {
                    this.sendControllerContent(servletContext, request, response, repositoryId);
                    break block8;
                }
                if ("login".equals(login)) {
                    this.login(servletContext, request, response, repositoryId);
                    break block8;
                }
                if (LOGIN_LOGOUT.equals(login)) {
                    this.logout(servletContext, request, response);
                    break block8;
                }
                throw new CmisObjectNotFoundException();
            }
            catch (Exception e) {
                if (e instanceof CmisBaseException) {
                    throw (CmisBaseException)e;
                }
                throw new CmisRuntimeException("Internal Error!", (Throwable)e);
            }
        }
    }

    protected void sendTokens(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONArray result = new JSONArray();
        if (!SimpleTokenHandlerSessionHelper.checkApplicationKey(request)) {
            String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(SimpleTokenHandlerSessionHelper.getKey(request));
            if (appId != null) {
                SimpleTokenHandlerSessionHelper.removeApplicationKey(request, appId);
            }
        } else {
            String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(SimpleTokenHandlerSessionHelper.getKey(request));
            for (int i = 0; i < 10; ++i) {
                String token = SimpleTokenHandlerSessionHelper.generateKey(appId);
                SimpleTokenHandlerSessionHelper.addToken(request, token);
                result.add((Object)token);
            }
        }
        this.printJSON(response, (JSONStreamAware)result);
    }

    protected void sendJavaScript(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String repositoryId) throws IOException {
        UrlBuilder baseUrl = URL_SERVICE_CALL.compileBaseUrl(request, repositoryId);
        URL url = new URL(baseUrl.toString());
        request.setAttribute("org.apache.chemistry.opencmis.domain", (Object)this.encodeJavaScriptString(url.getProtocol() + "://" + url.getHost() + (url.getPort() > -1 ? ":" + url.getPort() : "")));
        request.setAttribute("org.apache.chemistry.opencmis.serviceUrl", (Object)this.encodeJavaScriptString(baseUrl.toString()));
        request.setAttribute("org.apache.chemistry.opencmis.iframeUrl", (Object)this.encodeJavaScriptString(baseUrl.addParameter("login", (Object)LOGIN_CONTROLLER).toString()));
        response.setContentType("application/json; charset=UTF-8");
        RequestDispatcher dispatcher = servletContext.getRequestDispatcher("/WEB-INF/token/cmis.js.jsp");
        try {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Internal error!", (Throwable)e);
        }
    }

    protected void sendControllerContent(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String repositoryId) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        request.setAttribute("org.apache.chemistry.opencmis.loginUrl", (Object)this.encodeJavaScriptString(URL_SERVICE_CALL.compileBaseUrl(request, repositoryId).addParameter("login", (Object)"").toString()));
        RequestDispatcher dispatcher = servletContext.getRequestDispatcher("/WEB-INF/token/repository.jsp");
        try {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Internal error!", (Throwable)e);
        }
    }

    protected void login(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String repositoryId) throws IOException {
        if ("GET".equals(request.getMethod())) {
            this.showLoginForm(servletContext, request, response, null);
        } else if ("POST".equals(request.getMethod())) {
            this.authenticate(servletContext, request, response, repositoryId);
        } else {
            response.sendError(400);
        }
    }

    protected void showLoginForm(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String errorMessage) throws IOException {
        String formKey = SimpleTokenHandlerSessionHelper.getKey(request);
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(formKey);
        URL appUrl = SimpleTokenHandlerSessionHelper.getApplicationURL(request, appId);
        request.setAttribute("org.apache.chemistry.opencmis.formkey", (Object)formKey);
        request.setAttribute("org.apache.chemistry.opencmis.error", (Object)errorMessage);
        request.setAttribute("org.apache.chemistry.opencmis.appurl", (Object)this.encodeHTMLString(appUrl.toString()));
        response.setContentType("text/html; charset=UTF-8");
        RequestDispatcher dispatcher = servletContext.getRequestDispatcher("/WEB-INF/token/login.jsp");
        try {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Internal error!", (Throwable)e);
        }
    }

    protected void authenticate(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String repositoryId) throws IOException {
        if (SimpleTokenHandlerSessionHelper.checkFormKey(request)) {
            String trustapp = request.getParameter("trustapp");
            String user = request.getParameter("user");
            String password = request.getParameter("password");
            if (!"1".equals(trustapp)) {
                String error = "Please confirm that you trust the application!";
                this.showLoginForm(servletContext, request, response, error);
                return;
            }
            if (!this.authenticate(servletContext, request, response, user, password)) {
                String error = "Invalid credentials!";
                this.showLoginForm(servletContext, request, response, error);
                return;
            }
            String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(SimpleTokenHandlerSessionHelper.getKey(request));
            String appKey = SimpleTokenHandlerSessionHelper.generateKey(appId);
            SimpleTokenHandlerSessionHelper.setApplicationKey(request, appKey);
            SimpleTokenHandlerSessionHelper.setUser(request, appId, user);
            SimpleTokenHandlerSessionHelper.removeFormKey(request, appId);
            URL appURL = SimpleTokenHandlerSessionHelper.getApplicationURL(request, appId);
            response.sendRedirect(response.encodeRedirectURL(appURL.toString()));
            return;
        }
        String url = request.getParameter("url");
        if (url == null || url.trim().length() < 8 || !url.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            response.sendError(400);
            return;
        }
        URL appURL = null;
        try {
            appURL = new URL(url);
        }
        catch (Exception e) {
            response.sendError(400);
            return;
        }
        String loginKey = request.getParameter("key");
        if (loginKey == null || loginKey.trim().length() == 0) {
            String appId = SimpleTokenHandlerSessionHelper.generateAppId();
            loginKey = SimpleTokenHandlerSessionHelper.generateKey(appId);
            String formKey = SimpleTokenHandlerSessionHelper.generateKey(appId);
            SimpleTokenHandlerSessionHelper.setLoginKey(request, loginKey, formKey, appURL);
            String formURL = this.encodeJavaScriptString(URL_SERVICE_CALL.compileBaseUrl(request, repositoryId).addParameter("login", (Object)"login").addParameter("key", (Object)formKey).toString());
            JSONObject result = new JSONObject();
            result.put("ok", (Object)0);
            result.put("key", (Object)loginKey);
            result.put("url", (Object)formURL);
            this.printJSON(response, (JSONStreamAware)result);
            return;
        }
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(SimpleTokenHandlerSessionHelper.getKey(request));
        String appKey = SimpleTokenHandlerSessionHelper.getApplicationKey(request, appId);
        if (appKey == null || !SimpleTokenHandlerSessionHelper.checkLoginKey(request)) {
            SimpleTokenHandlerSessionHelper.removeLoginKey(request, appId);
            SimpleTokenHandlerSessionHelper.removeApplicationKey(request, appId);
            response.sendError(400);
            return;
        }
        SimpleTokenHandlerSessionHelper.removeLoginKey(request, appId);
        JSONObject result = new JSONObject();
        result.put("ok", (Object)1);
        result.put("key", (Object)appKey);
        this.printJSON(response, (JSONStreamAware)result);
    }

    protected abstract boolean authenticate(ServletContext var1, HttpServletRequest var2, HttpServletResponse var3, String var4, String var5);

    protected void logout(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(SimpleTokenHandlerSessionHelper.getKey(request));
        if (appId != null) {
            SimpleTokenHandlerSessionHelper.removeApplicationKey(request, appId);
        }
        JSONObject result = new JSONObject();
        result.put("ok", (Object)1);
        this.printJSON(response, (JSONStreamAware)result);
    }

    protected CmisServiceFactory getCmisServiceFactory(ServletContext servletContext) {
        CmisServiceFactory factory = (CmisServiceFactory)servletContext.getAttribute("org.apache.chemistry.opencmis.servicesfactory");
        if (factory == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        return factory;
    }

    protected void printJSON(HttpServletResponse response, JSONStreamAware json) throws IOException {
        response.setStatus(200);
        response.setContentType("application/json; charset=utf-8");
        response.addHeader("Cache-Control", "private, max-age=0");
        PrintWriter pw = response.getWriter();
        json.writeJSONString((Writer)pw);
        pw.flush();
    }

    protected String encodeJavaScriptString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String encodeHTMLString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ' ' || c == '.' || c == ',' || c == '-' || c == '_') {
                sb.append(c);
                continue;
            }
            if (c <= '\u001f' || c >= '\u007f' && c <= '\u009f') {
                sb.append(' ');
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append("&#x" + Integer.toHexString(c) + ";");
        }
        return sb.toString();
    }

    static class UrlServiceCall
    extends AbstractBrowserServiceCall {
        UrlServiceCall() {
        }

        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    }
}

