/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class VersioningService {

    public static class GetAllVersions
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            List versions = service.getAllVersions(repositoryId, objectId, null, filter, includeAllowableActions, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (versions == null) {
                throw new CmisRuntimeException("Versions are null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONArray jsonVersions = new JSONArray();
            for (ObjectData version : versions) {
                jsonVersions.add((Object)JSONConverter.convert((ObjectData)version, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat));
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonVersions, request, response);
        }
    }

    public static class CheckIn
    extends AbstractBrowserServiceCall {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String typeId = ((BrowserCallContextImpl)context).getTypeId();
            Boolean major = this.getBooleanParameter(request, "major");
            String checkinComment = this.getStringParameter(request, "checkinComment");
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            ControlParser cp = new ControlParser(request);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            Holder objectIdHolder = new Holder((Object)objectId);
            ContentStream contentStream = this.createContentStream(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            try {
                service.checkIn(repositoryId, objectIdHolder, major, this.createUpdateProperties(cp, typeId, null, Collections.singletonList(objectId), typeCache), contentStream, checkinComment, this.createPolicies(cp), this.createAddAcl(cp), this.createRemoveAcl(cp), null);
            }
            finally {
                this.closeContentStream(contentStream);
            }
            if (this.stopAfterService(service)) {
                return;
            }
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("New version is null!");
            }
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, object.getId()));
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class CancelCheckOut
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            if (this.stopBeforeService(service)) {
                return;
            }
            service.cancelCheckOut(repositoryId, objectId, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(200);
            this.writeEmpty(request, response);
        }
    }

    public static class CheckOut
    extends AbstractBrowserServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String token = this.getStringParameter(request, "token");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            DateTimeFormat dateTimeFormat = this.getDateTimeFormatParameter(request);
            if (this.stopBeforeService(service)) {
                return;
            }
            Holder checkOutId = new Holder((Object)objectId);
            service.checkOut(repositoryId, checkOutId, null, null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectData object = this.getSimpleObject(service, repositoryId, (String)checkOutId.getValue());
            if (object == null) {
                throw new CmisRuntimeException("PWC is null!");
            }
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct, (DateTimeFormat)dateTimeFormat);
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, object.getId()));
            this.setCookie(request, response, repositoryId, token, this.createCookieValue(201, object.getId(), null, null));
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }
}

