/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class ControlParser {
    public static final String CONTROL_PROP_ID_LOWER = "propertyid";
    private static final String CONTROL_PROP_VALUE_LOWER = "propertyvalue";
    private final HttpServletRequest request;
    private final Map<String, String> zeroDim = new HashMap<String, String>();
    private final Map<String, Map<Integer, String>> oneDim = new HashMap<String, Map<Integer, String>>();
    private final Map<String, Map<Integer, Map<Integer, String>>> twoDim = new HashMap<String, Map<Integer, Map<Integer, String>>>();

    public ControlParser(HttpServletRequest request) {
        this.request = request;
        this.parse();
    }

    private void parse() {
        Map controls = this.request.getParameterMap();
        if (controls == null) {
            return;
        }
        for (Map.Entry control : controls.entrySet()) {
            HashMap<Integer, String> list;
            Map<Integer, Object> values;
            String controlName = ((String)control.getKey()).trim().toLowerCase(Locale.ENGLISH);
            int firstIndex = ControlParser.getFirstIndex(controlName);
            if (firstIndex == -1) {
                this.zeroDim.put(controlName, ((String[])control.getValue())[0]);
                continue;
            }
            String strippedControlName = controlName.substring(0, controlName.indexOf(91));
            int secondIndex = ControlParser.getSecondIndex(controlName);
            if (secondIndex == -1) {
                values = this.oneDim.get(strippedControlName);
                if (values == null) {
                    values = new HashMap<Integer, String>();
                    this.oneDim.put(strippedControlName, values);
                }
                values.put(firstIndex, ((String[])control.getValue())[0]);
                continue;
            }
            values = this.twoDim.get(strippedControlName);
            if (values == null) {
                values = new HashMap<Integer, String>();
                this.twoDim.put(strippedControlName, values);
            }
            if ((list = (HashMap<Integer, String>)values.get(firstIndex)) == null) {
                list = new HashMap<Integer, String>();
                values.put(firstIndex, list);
            }
            list.put(secondIndex, ((String[])control.getValue())[0]);
        }
    }

    private static int getFirstIndex(String controlName) {
        int result = -1;
        int open = controlName.indexOf(91);
        int close = controlName.indexOf(93);
        if (open == -1 || close == -1 || close < open) {
            return result;
        }
        String indexStr = controlName.substring(open + 1, close);
        try {
            result = Integer.parseInt(indexStr);
            if (result < 0) {
                result = -1;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    private static int getSecondIndex(String controlName) {
        int result = -1;
        int open = controlName.indexOf("][");
        int close = controlName.lastIndexOf(93);
        if (open == -1 || close == -1 || close < open) {
            return result;
        }
        String indexStr = controlName.substring(open + 2, close);
        try {
            result = Integer.parseInt(indexStr);
            if (result < 0) {
                result = -1;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    private static List<String> convertToList(String controlName, Map<Integer, String> map) {
        if (map == null) {
            return null;
        }
        int count = map.size();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String value = map.get(i);
            if (value == null) {
                throw new CmisInvalidArgumentException(controlName + " has gaps!");
            }
            result.add(value);
        }
        return result;
    }

    public String getValue(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.zeroDim.get(controlName.toLowerCase(Locale.ENGLISH));
    }

    public List<String> getValues(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return ControlParser.convertToList(controlName, this.oneDim.get(controlName.toLowerCase(Locale.ENGLISH)));
    }

    public List<String> getValues(String controlName, int index) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        Map<Integer, Map<Integer, String>> map = this.twoDim.get(controlName.toLowerCase(Locale.ENGLISH));
        if (map == null) {
            return null;
        }
        return ControlParser.convertToList(controlName, map.get(index));
    }

    public Map<Integer, String> getOneDimMap(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.oneDim.get(controlName.toLowerCase(Locale.ENGLISH));
    }

    public Map<Integer, Map<Integer, String>> getTwoDimMap(String controlName) {
        if (controlName == null) {
            throw new IllegalArgumentException("controlName must not be null!");
        }
        return this.twoDim.get(controlName.toLowerCase(Locale.ENGLISH));
    }

    public Map<String, List<String>> getProperties() {
        Map<Integer, String> propertyIds = this.oneDim.get(CONTROL_PROP_ID_LOWER);
        if (propertyIds == null) {
            return null;
        }
        Map<Integer, String> oneDimPropValues = this.oneDim.get(CONTROL_PROP_VALUE_LOWER);
        Map<Integer, Map<Integer, String>> twoDimPropValues = this.twoDim.get(CONTROL_PROP_VALUE_LOWER);
        int count = propertyIds.size();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < count; ++i) {
            String propertyId = propertyIds.get(i);
            if (propertyId == null) {
                throw new CmisInvalidArgumentException("propertyId has gaps!");
            }
            List<String> values = null;
            if (oneDimPropValues != null && oneDimPropValues.containsKey(i)) {
                values = Collections.singletonList(oneDimPropValues.get(i));
            } else if (twoDimPropValues != null && twoDimPropValues.containsKey(i)) {
                values = new ArrayList<String>();
                Map<Integer, String> valuesMap = twoDimPropValues.get(i);
                if (valuesMap != null) {
                    int valueCount = valuesMap.size();
                    for (int j = 0; j < valueCount; ++j) {
                        String value = valuesMap.get(j);
                        if (value == null) {
                            throw new CmisInvalidArgumentException("propertyValue[" + i + "] has gaps!");
                        }
                        values.add(value);
                    }
                }
            }
            result.put(propertyId, values);
        }
        return result;
    }
}

